/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.jexcel;

import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.DateCell;
import jxl.ErrorCell;
import jxl.FormulaCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.transform.jexcel.JexcelUtil;
import org.jxls.transform.jexcel.WritableCellValue;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexcelCellData
extends CellData {
    static Logger logger = LoggerFactory.getLogger(JexcelCellData.class);
    CellType jxlCellType;
    CellFormat cellFormat;
    CellFeatures cellFeatures;

    public JexcelCellData(CellRef cellRef) {
        super(cellRef);
    }

    public static JexcelCellData createCellData(CellRef cellRef, Cell cell) {
        JexcelCellData cellData = new JexcelCellData(cellRef);
        cellData.readCell(cell);
        cellData.updateFormulaValue();
        return cellData;
    }

    public CellFormat getCellFormat() {
        return this.cellFormat;
    }

    private void readCell(Cell cell) {
        this.readCellGeneralInfo(cell);
        this.readCellContents(cell);
        this.readCellStyle(cell);
    }

    private void readCellGeneralInfo(Cell cell) {
        String comment;
        this.cellFeatures = cell.getCellFeatures();
        if (this.cellFeatures != null && (comment = this.cellFeatures.getComment()) != null) {
            this.setCellComment(comment);
        }
    }

    private void readCellContents(Cell cell) {
        this.jxlCellType = cell.getType();
        try {
            if (this.jxlCellType == CellType.LABEL) {
                LabelCell labelCell = (LabelCell)cell;
                this.cellValue = labelCell.getString();
                this.cellType = CellData.CellType.STRING;
            } else if (this.jxlCellType == CellType.NUMBER) {
                NumberCell numberCell = (NumberCell)cell;
                this.cellValue = numberCell.getValue();
                this.cellType = CellData.CellType.NUMBER;
            } else if (this.jxlCellType == CellType.DATE) {
                DateCell dateCell = (DateCell)cell;
                this.cellValue = dateCell.getDate();
                this.cellType = CellData.CellType.DATE;
            } else if (this.jxlCellType == CellType.BOOLEAN) {
                BooleanCell booleanCell = (BooleanCell)cell;
                this.cellValue = booleanCell.getValue();
                this.cellType = CellData.CellType.BOOLEAN;
            } else if (this.jxlCellType == CellType.STRING_FORMULA || this.jxlCellType == CellType.BOOLEAN_FORMULA || this.jxlCellType == CellType.DATE_FORMULA || this.jxlCellType == CellType.NUMBER_FORMULA || this.jxlCellType == CellType.FORMULA_ERROR) {
                FormulaCell formulaCell = (FormulaCell)cell;
                this.formula = formulaCell.getFormula();
                this.cellValue = this.formula;
                this.cellType = CellData.CellType.FORMULA;
            } else if (this.jxlCellType == CellType.ERROR && cell instanceof Formula) {
                Formula formulaCell = (Formula)cell;
                this.formula = formulaCell.getContents();
                this.cellValue = this.formula;
                this.cellType = CellData.CellType.FORMULA;
            } else if (this.jxlCellType == CellType.ERROR) {
                ErrorCell errorCell = (ErrorCell)cell;
                this.cellValue = errorCell.getErrorCode();
                this.cellType = CellData.CellType.ERROR;
            } else if (this.jxlCellType == CellType.EMPTY) {
                this.cellValue = null;
                this.cellType = CellData.CellType.BLANK;
            }
            this.evaluationResult = this.cellValue;
        }
        catch (FormulaException e) {
            logger.warn("Failed to read formula", (Throwable)e);
        }
    }

    private void readCellStyle(Cell cell) {
        this.cellFormat = cell.getCellFormat();
    }

    public void writeToCell(WritableSheet sheet, int col, int row, Context context) throws WriteException {
        this.evaluate(context);
        if (this.evaluationResult != null && this.evaluationResult instanceof WritableCellValue) {
            WritableCell cell = ((WritableCellValue)this.evaluationResult).writeToCell(sheet, col, row, context);
            this.updateCellStyle(cell);
        } else {
            WritableCell writableCell = this.createWritableCell(col, row);
            this.updateCellGeneralInfo(writableCell);
            this.updateCellStyle(writableCell);
            sheet.addCell(writableCell);
        }
    }

    private WritableCell createWritableCell(int col, int row) {
        Blank writableCell = null;
        switch (this.targetCellType) {
            case STRING: {
                if (this.evaluationResult instanceof byte[]) break;
                writableCell = new Label(col, row, (String)this.evaluationResult);
                break;
            }
            case BOOLEAN: {
                writableCell = new Boolean(col, row, ((java.lang.Boolean)this.evaluationResult).booleanValue());
                break;
            }
            case NUMBER: {
                double value = ((java.lang.Number)this.evaluationResult).doubleValue();
                writableCell = new Number(col, row, value);
                break;
            }
            case FORMULA: {
                if (Util.formulaContainsJointedCellRef((String)((String)this.evaluationResult))) {
                    writableCell = new Label(col, row, (String)this.evaluationResult);
                    break;
                }
                writableCell = new Formula(col, row, (String)this.evaluationResult);
                break;
            }
            case ERROR: {
                writableCell = new Blank(col, row);
                break;
            }
            default: {
                writableCell = new Blank(col, row);
            }
        }
        return writableCell;
    }

    private void updateCellGeneralInfo(WritableCell cell) {
        if (this.cellFeatures != null) {
            WritableCellFeatures writableCellFeatures = new WritableCellFeatures(this.cellFeatures);
            if (JexcelUtil.isJxComment(this.getCellComment())) {
                writableCellFeatures.removeComment();
            }
            cell.setCellFeatures(writableCellFeatures);
        }
    }

    private void updateCellStyle(WritableCell cell) {
        cell.setCellFormat(this.cellFormat);
    }
}

