/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.ImageType;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.transform.AbstractTransformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiSheetData;
import org.jxls.transform.poi.PoiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiTransformer
extends AbstractTransformer {
    public static final int MAX_COLUMN_TO_READ_COMMENT = 50;
    public static final String POI_CONTEXT_KEY = "util";
    static Logger logger = LoggerFactory.getLogger(PoiTransformer.class);
    Workbook workbook;
    private boolean useSxssf = false;
    private OutputStream outputStream;
    private InputStream inputStream;

    private PoiTransformer(Workbook workbook) {
        this.workbook = workbook;
    }

    public static PoiTransformer createTransformer(InputStream is, OutputStream os) throws IOException, InvalidFormatException {
        PoiTransformer transformer = PoiTransformer.createTransformer(is);
        transformer.outputStream = os;
        transformer.inputStream = is;
        return transformer;
    }

    public static PoiTransformer createTransformer(InputStream is) throws IOException, InvalidFormatException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return PoiTransformer.createTransformer(workbook);
    }

    public static PoiTransformer createTransformer(Workbook workbook) {
        PoiTransformer transformer = new PoiTransformer(workbook);
        transformer.readCellData();
        return transformer;
    }

    public static PoiTransformer createSxssfTransformer(Workbook workbook) {
        return PoiTransformer.createSxssfTransformer(workbook, 100, false);
    }

    public static PoiTransformer createSxssfTransformer(Workbook workbook, int rowAccessWindowSize, boolean compressTmpFiles) {
        PoiTransformer transformer = new PoiTransformer(workbook);
        transformer.readCellData();
        transformer.useSxssf = true;
        if (!(workbook instanceof XSSFWorkbook)) {
            throw new IllegalArgumentException("Failed to create POI Transformer using SXSSF API as the input workbook is not XSSFWorkbook");
        }
        transformer.workbook = new SXSSFWorkbook((XSSFWorkbook)workbook, rowAccessWindowSize, compressTmpFiles);
        return transformer;
    }

    public Context createInitialContext() {
        Context context = new Context();
        context.putVar(POI_CONTEXT_KEY, (Object)new PoiUtil());
        return context;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private void readCellData() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            PoiSheetData sheetData = PoiSheetData.createSheetData(sheet, this);
            this.sheetMap.put(sheetData.getSheetName(), sheetData);
        }
    }

    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context) {
        CellData cellData = this.getCellData(srcCellRef);
        if (cellData != null) {
            Cell destCell;
            Row destRow;
            cellData.addTargetPos(targetCellRef);
            if (targetCellRef == null || targetCellRef.getSheetName() == null) {
                logger.info("Target cellRef is null or has empty sheet name, cellRef=" + targetCellRef);
                return;
            }
            Sheet destSheet = this.workbook.getSheet(targetCellRef.getSheetName());
            if (destSheet == null) {
                destSheet = this.workbook.createSheet(targetCellRef.getSheetName());
                PoiUtil.copySheetProperties(this.workbook.getSheet(srcCellRef.getSheetName()), destSheet);
            }
            SheetData sheetData = (SheetData)this.sheetMap.get(srcCellRef.getSheetName());
            if (!this.isIgnoreColumnProps()) {
                destSheet.setColumnWidth(targetCellRef.getCol(), sheetData.getColumnWidth(srcCellRef.getCol()));
            }
            if ((destRow = destSheet.getRow(targetCellRef.getRow())) == null) {
                destRow = destSheet.createRow(targetCellRef.getRow());
            }
            if (!this.isIgnoreRowProps()) {
                destSheet.getRow(targetCellRef.getRow()).setHeight((short)sheetData.getRowData(srcCellRef.getRow()).getHeight());
            }
            if ((destCell = destRow.getCell(targetCellRef.getCol())) == null) {
                destCell = destRow.createCell(targetCellRef.getCol());
            }
            try {
                destCell.setCellType(3);
                ((PoiCellData)cellData).writeToCell(destCell, context, this);
                this.copyMergedRegions(cellData, targetCellRef);
            }
            catch (Exception e) {
                logger.error("Failed to write a cell with " + cellData + " and " + context, (Throwable)e);
            }
        }
    }

    private void copyMergedRegions(CellData sourceCellData, CellRef destCell) {
        if (sourceCellData.getSheetName() == null) {
            throw new IllegalArgumentException("Sheet name is null in copyMergedRegions");
        }
        PoiSheetData sheetData = (PoiSheetData)((Object)this.sheetMap.get(sourceCellData.getSheetName()));
        CellRangeAddress cellMergedRegion = null;
        for (CellRangeAddress mergedRegion : sheetData.getMergedRegions()) {
            if (mergedRegion.getFirstRow() != sourceCellData.getRow() || mergedRegion.getFirstColumn() != sourceCellData.getCol()) continue;
            cellMergedRegion = mergedRegion;
            break;
        }
        if (cellMergedRegion != null) {
            this.findAndRemoveExistingCellRegion(destCell);
            Sheet destSheet = this.workbook.getSheet(destCell.getSheetName());
            destSheet.addMergedRegion(new CellRangeAddress(destCell.getRow(), destCell.getRow() + cellMergedRegion.getLastRow() - cellMergedRegion.getFirstRow(), destCell.getCol(), destCell.getCol() + cellMergedRegion.getLastColumn() - cellMergedRegion.getFirstColumn()));
        }
    }

    private void findAndRemoveExistingCellRegion(CellRef cellRef) {
        Sheet destSheet = this.workbook.getSheet(cellRef.getSheetName());
        int numMergedRegions = destSheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress mergedRegion = destSheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() > cellRef.getRow() || mergedRegion.getLastRow() < cellRef.getRow() || mergedRegion.getFirstColumn() > cellRef.getCol() || mergedRegion.getLastColumn() < cellRef.getCol()) continue;
            destSheet.removeMergedRegion(i);
            break;
        }
    }

    public void setFormula(CellRef cellRef, String formulaString) {
        Cell poiCell;
        Row row;
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            sheet = this.workbook.createSheet(cellRef.getSheetName());
        }
        if ((row = sheet.getRow(cellRef.getRow())) == null) {
            row = sheet.createRow(cellRef.getRow());
        }
        if ((poiCell = row.getCell(cellRef.getCol())) == null) {
            poiCell = row.createCell(cellRef.getCol());
        }
        try {
            poiCell.setCellFormula(formulaString);
        }
        catch (Exception e) {
            logger.error("Failed to set formula = " + formulaString + " into cell = " + cellRef.getCellName(), (Throwable)e);
        }
    }

    public void clearCell(CellRef cellRef) {
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            return;
        }
        this.removeCellComment(sheet, cellRef.getRow(), cellRef.getCol());
        Row row = sheet.getRow(cellRef.getRow());
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(cellRef.getCol());
        if (cell == null) {
            if (sheet.getCellComment(cellRef.getRow(), cellRef.getCol()) != null) {
                cell = row.createCell(cellRef.getCol());
                cell.removeCellComment();
            }
            return;
        }
        cell.setCellType(3);
        cell.setCellStyle(this.workbook.getCellStyleAt((short)0));
        if (cell.getCellComment() != null) {
            cell.removeCellComment();
        }
    }

    private void removeCellComment(Sheet sheet, int row, int col) {
        Comment comment = sheet.getCellComment(row, col);
    }

    public List<CellData> getCommentedCells() {
        ArrayList<CellData> commentedCells = new ArrayList<CellData>();
        for (SheetData sheetData : this.sheetMap.values()) {
            for (RowData rowData : sheetData) {
                if (rowData == null) continue;
                for (CellData cellData : rowData) {
                    if (cellData == null || cellData.getCellComment() == null) continue;
                    commentedCells.add(cellData);
                }
                if (rowData.getNumberOfCells() != 0) continue;
                List<CellData> commentedCellData = this.readCommentsFromSheet(((PoiSheetData)sheetData).getSheet(), ((PoiRowData)rowData).getRow());
                commentedCells.addAll(commentedCellData);
            }
        }
        return commentedCells;
    }

    private void addImage(AreaRef areaRef, int imageIdx) {
        CreationHelper helper = this.workbook.getCreationHelper();
        Sheet sheet = this.workbook.getSheet(areaRef.getSheetName());
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(areaRef.getFirstCellRef().getCol());
        anchor.setRow1(areaRef.getFirstCellRef().getRow());
        anchor.setCol2(areaRef.getLastCellRef().getCol());
        anchor.setRow2(areaRef.getLastCellRef().getRow());
        drawing.createPicture(anchor, imageIdx);
    }

    public void addImage(AreaRef areaRef, byte[] imageBytes, ImageType imageType) {
        int poiPictureType = this.findPoiPictureTypeByImageType(imageType);
        int pictureIdx = this.workbook.addPicture(imageBytes, poiPictureType);
        this.addImage(areaRef, pictureIdx);
    }

    public void write() throws IOException {
        if (this.outputStream == null) {
            throw new IllegalStateException("Cannot write a workbook with an uninitialized output stream");
        }
        if (this.workbook == null) {
            throw new IllegalStateException("Cannot write an uninitialized workbook");
        }
        this.workbook.write(this.outputStream);
        this.outputStream.close();
    }

    private int findPoiPictureTypeByImageType(ImageType imageType) {
        int poiType = -1;
        if (imageType == null) {
            throw new IllegalArgumentException("Image type is undefined");
        }
        switch (imageType) {
            case PNG: {
                poiType = 6;
                break;
            }
            case JPEG: {
                poiType = 5;
                break;
            }
            case EMF: {
                poiType = 2;
                break;
            }
            case WMF: {
                poiType = 3;
                break;
            }
            case DIB: {
                poiType = 7;
                break;
            }
            case PICT: {
                poiType = 4;
            }
        }
        return poiType;
    }

    private List<CellData> readCommentsFromSheet(Sheet sheet, Row row) {
        ArrayList<CellData> commentDataCells = new ArrayList<CellData>();
        int rowNum = row.getRowNum();
        for (int i = 0; i <= 50; ++i) {
            Comment comment = sheet.getCellComment(rowNum, i);
            if (comment == null || comment.getString() == null) continue;
            CellData cellData = new CellData(new CellRef(sheet.getSheetName(), rowNum, i));
            cellData.setCellComment(comment.getString().getString());
            commentDataCells.add(cellData);
        }
        return commentDataCells;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public CellStyle getCellStyle(CellRef cellRef) {
        SheetData sheetData = (SheetData)this.sheetMap.get(cellRef.getSheetName());
        PoiCellData cellData = (PoiCellData)sheetData.getRowData(cellRef.getRow()).getCellData(cellRef.getCol());
        return cellData.getCellStyle();
    }

    public void deleteSheet(String sheetName) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.workbook.removeSheetAt(sheetIndex);
    }

    public void setHidden(String sheetName, boolean hidden) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.workbook.setSheetHidden(sheetIndex, hidden);
    }
}

