/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.ImageType;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.common.Size;
import org.jxls.transform.AbstractTransformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiSheetData;
import org.jxls.transform.poi.PoiUtil;
import org.jxls.util.CannotOpenWorkbookException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiTransformer
extends AbstractTransformer {
    private static final int MAX_COLUMN_TO_READ_COMMENT = 50;
    public static final String POI_CONTEXT_KEY = "util";
    private static Logger logger = LoggerFactory.getLogger(PoiTransformer.class);
    private Workbook workbook;
    private OutputStream outputStream;
    private InputStream inputStream;
    private Integer lastCommentedColumn = 50;
    private final boolean isSXSSF;
    private CellStyle cellStyle;

    private PoiTransformer(Workbook workbook) {
        this(workbook, false);
    }

    public PoiTransformer(Workbook workbook, boolean streaming) {
        this(workbook, streaming, 100, false, false);
    }

    public PoiTransformer(Workbook workbook, boolean streaming, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        this.workbook = workbook;
        this.isSXSSF = streaming;
        this.readCellData();
        if (this.isSXSSF) {
            if (this.workbook instanceof XSSFWorkbook) {
                this.workbook = new SXSSFWorkbook((XSSFWorkbook)this.workbook, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
            } else {
                throw new IllegalArgumentException("Failed to create POI Transformer using SXSSF API as the input workbook is not XSSFWorkbook");
            }
        }
    }

    protected boolean isStreaming() {
        return this.isSXSSF;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public static PoiTransformer createTransformer(InputStream is, OutputStream os) {
        PoiTransformer transformer = PoiTransformer.createTransformer(is);
        transformer.setOutputStream(os);
        transformer.setInputStream(is);
        return transformer;
    }

    public static PoiTransformer createTransformer(InputStream is) {
        Workbook workbook;
        try {
            workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            throw new CannotOpenWorkbookException((Throwable)e);
        }
        return PoiTransformer.createTransformer(workbook);
    }

    public static PoiTransformer createTransformer(Workbook workbook) {
        return new PoiTransformer(workbook);
    }

    public static PoiTransformer createSxssfTransformer(Workbook workbook) {
        return PoiTransformer.createSxssfTransformer(workbook, 100, false);
    }

    public static PoiTransformer createSxssfTransformer(Workbook workbook, int rowAccessWindowSize, boolean compressTmpFiles) {
        return PoiTransformer.createSxssfTransformer(workbook, rowAccessWindowSize, compressTmpFiles, false);
    }

    public static PoiTransformer createSxssfTransformer(Workbook workbook, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        return new PoiTransformer(workbook, true, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
    }

    public static Context createInitialContext() {
        Context context = new Context();
        context.putVar(POI_CONTEXT_KEY, (Object)new PoiUtil());
        return context;
    }

    public boolean isForwardOnly() {
        return this.isStreaming();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Integer getLastCommentedColumn() {
        return this.lastCommentedColumn;
    }

    public void setLastCommentedColumn(Integer lastCommentedColumn) {
        this.lastCommentedColumn = lastCommentedColumn;
    }

    private void readCellData() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            PoiSheetData sheetData = PoiSheetData.createSheetData(sheet, this);
            this.sheetMap.put(sheetData.getSheetName(), sheetData);
        }
    }

    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag) {
        Row destRow;
        CellData cellData = this.isTransformable(srcCellRef, targetCellRef);
        if (cellData == null) {
            return;
        }
        Sheet destSheet = this.workbook.getSheet(targetCellRef.getSheetName());
        if (destSheet == null) {
            destSheet = this.workbook.createSheet(targetCellRef.getSheetName());
            PoiUtil.copySheetProperties(this.workbook.getSheet(srcCellRef.getSheetName()), destSheet);
        }
        if ((destRow = destSheet.getRow(targetCellRef.getRow())) == null) {
            destRow = destSheet.createRow(targetCellRef.getRow());
        }
        this.transformCell(srcCellRef, targetCellRef, context, updateRowHeightFlag, cellData, destSheet, destRow);
    }

    protected CellData isTransformable(CellRef srcCellRef, CellRef targetCellRef) {
        CellData cellData = this.getCellData(srcCellRef);
        if (cellData != null && (targetCellRef == null || targetCellRef.getSheetName() == null)) {
            logger.info("Target cellRef is null or has empty sheet name, cellRef=" + targetCellRef);
            return null;
        }
        return cellData;
    }

    protected void transformCell(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag, CellData cellData, Sheet destSheet, Row destRow) {
        Cell destCell;
        SheetData sheetData = (SheetData)this.sheetMap.get(srcCellRef.getSheetName());
        if (!this.isIgnoreColumnProps()) {
            destSheet.setColumnWidth(targetCellRef.getCol(), sheetData.getColumnWidth(srcCellRef.getCol()));
        }
        if (updateRowHeightFlag && !this.isIgnoreRowProps()) {
            destRow.setHeight((short)sheetData.getRowData(srcCellRef.getRow()).getHeight());
        }
        if ((destCell = destRow.getCell(targetCellRef.getCol())) == null) {
            destCell = destRow.createCell(targetCellRef.getCol());
        }
        try {
            destCell.setCellType(CellType.BLANK);
            ((PoiCellData)cellData).writeToCell(destCell, context, this);
            this.copyMergedRegions(cellData, targetCellRef);
        }
        catch (Exception e) {
            logger.error("Failed to write a cell with {} and context keys {}", new Object[]{cellData, context.toMap().keySet(), e});
        }
    }

    public void resetArea(AreaRef areaRef) {
        this.removeMergedRegions(areaRef);
        this.removeConditionalFormatting(areaRef);
    }

    private void removeMergedRegions(AreaRef areaRef) {
        int numMergedRegions;
        Sheet destSheet = this.workbook.getSheet(areaRef.getSheetName());
        for (int i = numMergedRegions = destSheet.getNumMergedRegions(); i > 0; --i) {
            destSheet.removeMergedRegion(i - 1);
        }
    }

    private void removeConditionalFormatting(AreaRef areaRef) {
        Sheet destSheet = this.workbook.getSheet(areaRef.getSheetName());
        CellRangeAddress areaRange = CellRangeAddress.valueOf((String)areaRef.toString());
        SheetConditionalFormatting sheetConditionalFormatting = destSheet.getSheetConditionalFormatting();
        int numConditionalFormattings = sheetConditionalFormatting.getNumConditionalFormattings();
        for (int index = 0; index < numConditionalFormattings; ++index) {
            ConditionalFormatting conditionalFormatting = sheetConditionalFormatting.getConditionalFormattingAt(index);
            CellRangeAddress[] ranges = conditionalFormatting.getFormattingRanges();
            ArrayList<CellRangeAddress> newRanges = new ArrayList<CellRangeAddress>();
            for (CellRangeAddress range : ranges) {
                if (areaRange.isInRange(range.getFirstRow(), range.getFirstColumn()) && areaRange.isInRange(range.getLastRow(), range.getLastColumn())) continue;
                newRanges.add(range);
            }
            conditionalFormatting.setFormattingRanges(newRanges.toArray(new CellRangeAddress[0]));
        }
    }

    protected final void copyMergedRegions(CellData sourceCellData, CellRef destCell) {
        if (sourceCellData.getSheetName() == null) {
            throw new IllegalArgumentException("Sheet name is null in copyMergedRegions");
        }
        PoiSheetData sheetData = (PoiSheetData)((Object)this.sheetMap.get(sourceCellData.getSheetName()));
        CellRangeAddress cellMergedRegion = null;
        for (CellRangeAddress mergedRegion : sheetData.getMergedRegions()) {
            if (mergedRegion.getFirstRow() != sourceCellData.getRow() || mergedRegion.getFirstColumn() != sourceCellData.getCol()) continue;
            cellMergedRegion = mergedRegion;
            break;
        }
        if (cellMergedRegion != null) {
            this.findAndRemoveExistingCellRegion(destCell);
            Sheet destSheet = this.workbook.getSheet(destCell.getSheetName());
            destSheet.addMergedRegion(new CellRangeAddress(destCell.getRow(), destCell.getRow() + cellMergedRegion.getLastRow() - cellMergedRegion.getFirstRow(), destCell.getCol(), destCell.getCol() + cellMergedRegion.getLastColumn() - cellMergedRegion.getFirstColumn()));
        }
    }

    protected final void findAndRemoveExistingCellRegion(CellRef cellRef) {
        Sheet destSheet = this.workbook.getSheet(cellRef.getSheetName());
        int numMergedRegions = destSheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress mergedRegion = destSheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() > cellRef.getRow() || mergedRegion.getLastRow() < cellRef.getRow() || mergedRegion.getFirstColumn() > cellRef.getCol() || mergedRegion.getLastColumn() < cellRef.getCol()) continue;
            destSheet.removeMergedRegion(i);
            break;
        }
    }

    public void setFormula(CellRef cellRef, String formulaString) {
        Cell poiCell;
        Row row;
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            sheet = this.workbook.createSheet(cellRef.getSheetName());
        }
        if ((row = sheet.getRow(cellRef.getRow())) == null) {
            row = sheet.createRow(cellRef.getRow());
        }
        if ((poiCell = row.getCell(cellRef.getCol())) == null) {
            poiCell = row.createCell(cellRef.getCol());
        }
        try {
            poiCell.setCellFormula(formulaString);
            this.clearCellValue(poiCell);
        }
        catch (Exception e) {
            logger.error("Failed to set formula = " + formulaString + " into cell = " + cellRef.getCellName(), (Throwable)e);
        }
    }

    protected void clearCellValue(Cell poiCell) {
        CTCell cell;
        if (poiCell instanceof XSSFCell && (cell = ((XSSFCell)poiCell).getCTCell()).isSetV()) {
            cell.unsetV();
        }
    }

    public void clearCell(CellRef cellRef) {
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            return;
        }
        this.removeCellComment(sheet, cellRef.getRow(), cellRef.getCol());
        Row row = this.getRowForClearCell(sheet, cellRef);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(cellRef.getCol());
        if (cell == null) {
            CellAddress cellAddress = new CellAddress(cellRef.getRow(), cellRef.getCol());
            if (sheet.getCellComment(cellAddress) != null) {
                cell = row.createCell(cellRef.getCol());
                cell.removeCellComment();
            }
            return;
        }
        cell.setCellType(CellType.BLANK);
        cell.setCellStyle(this.workbook.getCellStyleAt(0));
        if (cell.getCellComment() != null) {
            cell.removeCellComment();
        }
        this.findAndRemoveExistingCellRegion(cellRef);
    }

    protected Row getRowForClearCell(Sheet sheet, CellRef cellRef) {
        return sheet.getRow(cellRef.getRow());
    }

    protected final void removeCellComment(Sheet sheet, int rowNum, int colNum) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(colNum);
        if (cell == null) {
            return;
        }
        cell.removeCellComment();
    }

    public List<CellData> getCommentedCells() {
        ArrayList<CellData> commentedCells = new ArrayList<CellData>();
        for (SheetData sheetData : this.sheetMap.values()) {
            for (RowData rowData : sheetData) {
                if (rowData == null) continue;
                int row = ((PoiRowData)rowData).getRow().getRowNum();
                List<CellData> cellDataList = this.readCommentsFromSheet(((PoiSheetData)sheetData).getSheet(), row);
                commentedCells.addAll(cellDataList);
            }
        }
        return commentedCells;
    }

    private void addImage(AreaRef areaRef, int imageIdx, Double scaleX, Double scaleY) {
        boolean pictureResizeFlag = scaleX != null && scaleY != null;
        CreationHelper helper = this.workbook.getCreationHelper();
        Sheet sheet = this.workbook.getSheet(areaRef.getSheetName());
        if (sheet == null) {
            sheet = this.workbook.createSheet(areaRef.getSheetName());
        }
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(areaRef.getFirstCellRef().getCol());
        anchor.setRow1(areaRef.getFirstCellRef().getRow());
        if (pictureResizeFlag) {
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
            anchor.setCol2(-1);
            anchor.setRow2(-1);
        } else {
            anchor.setCol2(areaRef.getLastCellRef().getCol());
            anchor.setRow2(areaRef.getLastCellRef().getRow());
        }
        Picture picture = drawing.createPicture(anchor, imageIdx);
        if (pictureResizeFlag) {
            picture.resize(scaleX.doubleValue(), scaleY.doubleValue());
        }
    }

    public void addImage(AreaRef areaRef, byte[] imageBytes, ImageType imageType, Double scaleX, Double scaleY) {
        int poiPictureType = this.findPoiPictureTypeByImageType(imageType);
        int pictureIdx = this.workbook.addPicture(imageBytes, poiPictureType);
        this.addImage(areaRef, pictureIdx, scaleX, scaleY);
    }

    public void addImage(AreaRef areaRef, byte[] imageBytes, ImageType imageType) {
        int poiPictureType = this.findPoiPictureTypeByImageType(imageType);
        int pictureIdx = this.workbook.addPicture(imageBytes, poiPictureType);
        this.addImage(areaRef, pictureIdx, null, null);
    }

    public void write() throws IOException {
        this.writeButNotCloseStream();
        this.outputStream.close();
        this.dispose();
    }

    public void writeButNotCloseStream() throws IOException {
        if (this.outputStream == null) {
            throw new IllegalStateException("Cannot write a workbook with an uninitialized output stream");
        }
        if (this.workbook == null) {
            throw new IllegalStateException("Cannot write an uninitialized workbook");
        }
        if (!this.isStreaming() && this.isEvaluateFormulas()) {
            this.workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
        this.workbook.write(this.outputStream);
    }

    public void dispose() {
        try {
            if (this.workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
        }
        catch (Exception e) {
            logger.warn("Error disposing streamed workbook", (Throwable)e);
        }
    }

    private int findPoiPictureTypeByImageType(ImageType imageType) {
        int poiType = -1;
        if (imageType == null) {
            throw new IllegalArgumentException("Image type is undefined");
        }
        switch (imageType) {
            case PNG: {
                poiType = 6;
                break;
            }
            case JPEG: {
                poiType = 5;
                break;
            }
            case EMF: {
                poiType = 2;
                break;
            }
            case WMF: {
                poiType = 3;
                break;
            }
            case DIB: {
                poiType = 7;
                break;
            }
            case PICT: {
                poiType = 4;
            }
        }
        return poiType;
    }

    private List<CellData> readCommentsFromSheet(Sheet sheet, int rowNum) {
        ArrayList<CellData> commentDataCells = new ArrayList<CellData>();
        for (int i = 0; i <= this.lastCommentedColumn; ++i) {
            CellAddress cellAddress = new CellAddress(rowNum, i);
            Comment comment = sheet.getCellComment(cellAddress);
            if (comment == null || comment.getString() == null) continue;
            CellData cellData = new CellData(new CellRef(sheet.getSheetName(), rowNum, i));
            cellData.setCellComment(comment.getString().getString());
            commentDataCells.add(cellData);
        }
        return commentDataCells;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public CellStyle getCellStyle(CellRef cellRef) {
        SheetData sheetData = (SheetData)this.sheetMap.get(cellRef.getSheetName());
        PoiCellData cellData = (PoiCellData)sheetData.getRowData(cellRef.getRow()).getCellData(cellRef.getCol());
        return cellData.getCellStyle();
    }

    public boolean deleteSheet(String sheetName) {
        if (super.deleteSheet(sheetName)) {
            int sheetIndex = this.workbook.getSheetIndex(sheetName);
            this.workbook.removeSheetAt(sheetIndex);
            return true;
        }
        logger.warn("Failed to find '{}' worksheet in a sheet map. Skipping the deletion.", (Object)sheetName);
        return false;
    }

    public void setHidden(String sheetName, boolean hidden) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.workbook.setSheetHidden(sheetIndex, hidden);
    }

    public void updateRowHeight(String srcSheetName, int srcRowNum, String targetSheetName, int targetRowNum) {
        Row targetRow;
        if (this.isSXSSF) {
            return;
        }
        SheetData sheetData = (SheetData)this.sheetMap.get(srcSheetName);
        RowData rowData = sheetData.getRowData(srcRowNum);
        Sheet sheet = this.workbook.getSheet(targetSheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(targetSheetName);
        }
        if ((targetRow = sheet.getRow(targetRowNum)) == null) {
            targetRow = sheet.createRow(targetRowNum);
        }
        short srcHeight = rowData != null ? (short)rowData.getHeight() : sheet.getDefaultRowHeight();
        targetRow.setHeight(srcHeight);
    }

    public XSSFWorkbook getXSSFWorkbook() {
        if (this.workbook instanceof SXSSFWorkbook) {
            return ((SXSSFWorkbook)this.workbook).getXSSFWorkbook();
        }
        if (this.workbook instanceof XSSFWorkbook) {
            return (XSSFWorkbook)this.workbook;
        }
        return null;
    }

    public void adjustTableSize(CellRef ref, Size size) {
        XSSFWorkbook xwb = this.getXSSFWorkbook();
        if (size.getHeight() > 0 && xwb != null) {
            XSSFSheet sheet = xwb.getSheet(ref.getSheetName());
            if (sheet == null) {
                logger.error("Can not access sheet '{}'", (Object)ref.getSheetName());
            } else {
                for (XSSFTable table : sheet.getTables()) {
                    AreaRef areaRef = new AreaRef(table.getSheetName() + "!" + table.getCTTable().getRef());
                    if (!areaRef.contains(ref)) continue;
                    areaRef.getLastCellRef().setRow(ref.getRow() + size.getHeight() - 1);
                    table.getCTTable().setRef(areaRef.getFirstCellRef().toString(true) + ":" + areaRef.getLastCellRef().toString(true));
                }
            }
        }
    }

    public void mergeCells(CellRef cellRef, int rows, int cols) {
        Sheet sheet = this.getWorkbook().getSheet(cellRef.getSheetName());
        CellRangeAddress region = new CellRangeAddress(cellRef.getRow(), cellRef.getRow() + rows - 1, cellRef.getCol(), cellRef.getCol() + cols - 1);
        sheet.addMergedRegion(region);
        try {
            this.cellStyle = this.getCellStyle(cellRef);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        for (int i = region.getFirstRow(); i <= region.getLastRow(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                row = sheet.createRow(i);
            }
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                if (this.cellStyle == null) {
                    cell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
                    cell.getCellStyle().setVerticalAlignment(VerticalAlignment.CENTER);
                    continue;
                }
                cell.setCellStyle(this.cellStyle);
            }
        }
    }
}

