/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.common.Context;
import org.jxls.logging.JxlsLogger;

public class PoiExceptionLogger
implements JxlsLogger {
    public void handleCellException(Exception e, String cell, Context context) {
        this.error(e, "Failed to write a cell with " + cell);
    }

    public void handleFormulaException(Exception e, String cell, String formula) {
        this.error(e, "Failed to set formula = " + formula + " into cell = " + cell);
    }

    public void handleTransformException(Exception e, String sourceCell, String targetCell) {
        this.error(e, "Failed to transform " + sourceCell + " into " + targetCell);
    }

    public void handleUpdateRowHeightsException(Exception e, int sourceRow, int targetRow) {
        this.error(e, "Failed to update row height for src row=" + sourceRow + " and target row=" + targetRow);
    }

    public void handleEvaluationException(Exception e, String cell, String expression) {
        this.warn(e, "Failed to evaluate collection expression " + expression);
    }

    public void handleGetObjectPropertyException(Exception e, Object obj, String propertyName) {
        this.warn(e, "Failed to get property '" + propertyName + "' of object " + obj);
    }

    public void handleSetObjectPropertyException(Exception e, Object obj, String propertyName, String propertyValue) {
        this.warn(e, "Failed to set property '" + propertyName + "' to value '" + propertyValue + "' for object " + obj);
    }

    public void handleSheetNameChange(String invalidSheetName, String newSheetName) {
        this.info("Change invalid sheet name " + invalidSheetName + " to " + newSheetName);
    }

    public void debug(String msg) {
    }

    public void info(String msg) {
        System.out.println("JXLS [INFO] " + msg);
    }

    public void warn(String msg) {
        this.write("WARN", msg, null);
    }

    public void warn(Throwable e, String msg) {
        this.write("WARN", msg, e);
    }

    public void error(String msg) {
        this.write("ERROR", msg, null);
    }

    public void error(Throwable e, String msg) {
        this.write("ERROR", msg, e);
    }

    protected void write(String level, String msg, Throwable e) {
        System.err.println("JXLS [" + level + "] " + msg);
        if (e != null) {
            e.printStackTrace();
        }
    }
}

