/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.util.WorkbookUtil;
import org.jxls.logging.JxlsLogger;
import org.jxls.transform.SafeSheetNameBuilder;

public class PoiSafeSheetNameBuilder
implements SafeSheetNameBuilder {
    private final Set<String> usedSheetNames = new HashSet<String>();

    public String createSafeSheetName(String givenSheetName, int index, JxlsLogger logger) {
        String sheetName = WorkbookUtil.createSafeSheetName((String)givenSheetName);
        int serialNumber = this.getFirstSerialNumber();
        String newName = sheetName;
        while (this.usedSheetNames.contains(newName)) {
            String nameWithNumber;
            int len = sheetName.length();
            while (!(newName = WorkbookUtil.createSafeSheetName((String)(nameWithNumber = this.addSerialNumber(sheetName.substring(0, len--), serialNumber)))).equals(nameWithNumber)) {
            }
            ++serialNumber;
        }
        if (!givenSheetName.equals(newName)) {
            logger.handleSheetNameChange(givenSheetName, sheetName);
        }
        this.usedSheetNames.add(newName);
        return newName;
    }

    protected int getFirstSerialNumber() {
        return 1;
    }

    protected String addSerialNumber(String text, int serialNumber) {
        return text + "(" + serialNumber + ")";
    }
}

