/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.common.PoiExceptionLogger;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.common.Size;
import org.jxls.logging.JxlsLogger;
import org.jxls.transform.AbstractTransformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiSheetData;
import org.jxls.transform.poi.PoiUtil;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;

public class PoiTransformer
extends AbstractTransformer {
    private Workbook workbook;
    private OutputStream outputStream;
    private InputStream inputStream;
    private final boolean isSXSSF;
    private JxlsLogger logger = new PoiExceptionLogger();

    public PoiTransformer(Workbook workbook, boolean streaming) {
        this(workbook, streaming, 100, false, false);
    }

    public PoiTransformer(Workbook workbook, boolean streaming, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        this.workbook = workbook;
        this.isSXSSF = streaming;
        this.readCellData();
        if (this.isSXSSF) {
            Workbook workbook2 = this.workbook;
            if (workbook2 instanceof XSSFWorkbook) {
                XSSFWorkbook xwb = (XSSFWorkbook)workbook2;
                this.workbook = new SXSSFWorkbook(xwb, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
            } else {
                throw new IllegalArgumentException("Failed to create POI Transformer using SXSSF API as the input workbook is not XSSFWorkbook");
            }
        }
    }

    protected boolean isStreaming() {
        return this.isSXSSF;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public boolean isForwardOnly() {
        return this.isStreaming();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private void readCellData() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            PoiSheetData sheetData = PoiSheetData.createSheetData(sheet, this);
            this.sheetMap.put(sheetData.getSheetName(), sheetData);
        }
    }

    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag) {
        Row destRow;
        CellData cellData = this.isTransformable(srcCellRef, targetCellRef);
        if (cellData == null) {
            return;
        }
        Sheet destSheet = this.workbook.getSheet(targetCellRef.getSheetName());
        if (destSheet == null) {
            destSheet = this.workbook.createSheet(targetCellRef.getSheetName());
            PoiUtil.copySheetProperties(this.workbook.getSheet(srcCellRef.getSheetName()), destSheet);
        }
        if ((destRow = destSheet.getRow(targetCellRef.getRow())) == null) {
            destRow = destSheet.createRow(targetCellRef.getRow());
        }
        this.transformCell(srcCellRef, targetCellRef, context, updateRowHeightFlag, cellData, destSheet, destRow);
    }

    protected CellData isTransformable(CellRef srcCellRef, CellRef targetCellRef) {
        CellData cellData = this.getCellData(srcCellRef);
        if (cellData != null && (targetCellRef == null || targetCellRef.getSheetName() == null)) {
            this.getLogger().info("targetCellRef is null or has empty sheet name, cellRef=" + targetCellRef);
            return null;
        }
        return cellData;
    }

    protected void transformCell(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag, CellData cellData, Sheet destSheet, Row destRow) {
        Cell destCell;
        SheetData sheetData = (SheetData)this.sheetMap.get(srcCellRef.getSheetName());
        if (!this.isIgnoreColumnProps()) {
            destSheet.setColumnWidth(targetCellRef.getCol(), sheetData.getColumnWidth(srcCellRef.getCol()));
        }
        if (updateRowHeightFlag && !this.isIgnoreRowProps()) {
            destRow.setHeight((short)sheetData.getRowData(srcCellRef.getRow()).getHeight());
        }
        if ((destCell = destRow.getCell(targetCellRef.getCol())) == null) {
            destCell = destRow.createCell(targetCellRef.getCol());
        }
        try {
            destCell.setBlank();
            ((PoiCellData)cellData).writeToCell(destCell, context, this);
            this.copyMergedRegions(cellData, targetCellRef);
        }
        catch (Exception e) {
            this.getLogger().handleCellException(e, cellData.toString(), context);
        }
    }

    public JxlsLogger getLogger() {
        if (this.logger == null) {
            throw new JxlsException("Transformer has no logger");
        }
        return this.logger;
    }

    public void setLogger(JxlsLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger must not be null");
        }
        this.logger = logger;
    }

    public void resetArea(AreaRef areaRef) {
        this.removeMergedRegions(areaRef);
        this.removeConditionalFormatting(areaRef);
    }

    private void removeMergedRegions(AreaRef areaRef) {
        int numMergedRegions;
        Sheet destSheet = this.workbook.getSheet(areaRef.getSheetName());
        for (int i = numMergedRegions = destSheet.getNumMergedRegions(); i > 0; --i) {
            destSheet.removeMergedRegion(i - 1);
        }
    }

    private void removeConditionalFormatting(AreaRef areaRef) {
        Sheet destSheet = this.workbook.getSheet(areaRef.getSheetName());
        CellRangeAddress areaRange = CellRangeAddress.valueOf((String)areaRef.toString());
        SheetConditionalFormatting sheetConditionalFormatting = destSheet.getSheetConditionalFormatting();
        int numConditionalFormattings = sheetConditionalFormatting.getNumConditionalFormattings();
        for (int index = 0; index < numConditionalFormattings; ++index) {
            ConditionalFormatting conditionalFormatting = sheetConditionalFormatting.getConditionalFormattingAt(index);
            CellRangeAddress[] ranges = conditionalFormatting.getFormattingRanges();
            ArrayList<CellRangeAddress> newRanges = new ArrayList<CellRangeAddress>();
            for (CellRangeAddress range : ranges) {
                if (areaRange.isInRange(range.getFirstRow(), range.getFirstColumn()) && areaRange.isInRange(range.getLastRow(), range.getLastColumn())) continue;
                newRanges.add(range);
            }
            conditionalFormatting.setFormattingRanges(newRanges.toArray(new CellRangeAddress[0]));
        }
    }

    protected final void copyMergedRegions(CellData sourceCellData, CellRef destCell) {
        if (sourceCellData.getSheetName() == null) {
            throw new IllegalArgumentException("Sheet name is null in copyMergedRegions");
        }
        PoiSheetData sheetData = (PoiSheetData)((Object)this.sheetMap.get(sourceCellData.getSheetName()));
        CellRangeAddress cellMergedRegion = null;
        for (CellRangeAddress mergedRegion : sheetData.getMergedRegions()) {
            if (mergedRegion.getFirstRow() != sourceCellData.getRow() || mergedRegion.getFirstColumn() != sourceCellData.getCol()) continue;
            cellMergedRegion = mergedRegion;
            break;
        }
        if (cellMergedRegion != null) {
            this.findAndRemoveExistingCellRegion(destCell);
            Sheet destSheet = this.workbook.getSheet(destCell.getSheetName());
            destSheet.addMergedRegion(new CellRangeAddress(destCell.getRow(), destCell.getRow() + cellMergedRegion.getLastRow() - cellMergedRegion.getFirstRow(), destCell.getCol(), destCell.getCol() + cellMergedRegion.getLastColumn() - cellMergedRegion.getFirstColumn()));
        }
    }

    protected final void findAndRemoveExistingCellRegion(CellRef cellRef) {
        Sheet destSheet = this.workbook.getSheet(cellRef.getSheetName());
        int numMergedRegions = destSheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress mergedRegion = destSheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() > cellRef.getRow() || mergedRegion.getLastRow() < cellRef.getRow() || mergedRegion.getFirstColumn() > cellRef.getCol() || mergedRegion.getLastColumn() < cellRef.getCol()) continue;
            destSheet.removeMergedRegion(i);
            break;
        }
    }

    public void setFormula(CellRef cellRef, String formulaString) {
        Cell poiCell;
        Row row;
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            sheet = this.workbook.createSheet(cellRef.getSheetName());
        }
        if ((row = sheet.getRow(cellRef.getRow())) == null) {
            row = sheet.createRow(cellRef.getRow());
        }
        if ((poiCell = row.getCell(cellRef.getCol())) == null) {
            poiCell = row.createCell(cellRef.getCol());
        }
        try {
            poiCell.setCellFormula(formulaString);
            this.clearCellValue(poiCell);
        }
        catch (Exception e) {
            this.getLogger().handleFormulaException(e, cellRef.getCellName(), formulaString);
        }
    }

    protected void clearCellValue(Cell poiCell) {
        CTCell cell;
        if (poiCell instanceof XSSFCell && (cell = ((XSSFCell)poiCell).getCTCell()).isSetV()) {
            cell.unsetV();
        }
    }

    public void clearCell(CellRef cellRef) {
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            return;
        }
        this.removeCellComment(sheet, cellRef.getRow(), cellRef.getCol());
        Row row = this.getRowForClearCell(sheet, cellRef);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(cellRef.getCol());
        if (cell == null) {
            CellAddress cellAddress = new CellAddress(cellRef.getRow(), cellRef.getCol());
            if (sheet.getCellComment(cellAddress) != null) {
                cell = row.createCell(cellRef.getCol());
                cell.removeCellComment();
            }
            return;
        }
        cell.setBlank();
        cell.setCellStyle(this.workbook.getCellStyleAt(0));
        if (cell.getCellComment() != null) {
            cell.removeCellComment();
        }
        this.findAndRemoveExistingCellRegion(cellRef);
    }

    protected Row getRowForClearCell(Sheet sheet, CellRef cellRef) {
        return sheet.getRow(cellRef.getRow());
    }

    protected final void removeCellComment(Sheet sheet, int rowNum, int colNum) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(colNum);
        if (cell == null) {
            return;
        }
        cell.removeCellComment();
    }

    public List<CellData> getCommentedCells() {
        ArrayList<CellData> commentedCells = new ArrayList<CellData>();
        for (SheetData sheetData : this.sheetMap.values()) {
            for (RowData rowData : sheetData) {
                if (rowData == null) continue;
                int row = ((PoiRowData)rowData).getRow().getRowNum();
                List<CellData> cellDataList = this.readCommentsFromSheet(((PoiSheetData)sheetData).getSheet(), row);
                commentedCells.addAll(cellDataList);
            }
        }
        return commentedCells;
    }

    public void write() throws IOException {
        this.writeButNotCloseStream();
        this.outputStream.close();
        this.dispose();
    }

    public void writeButNotCloseStream() throws IOException {
        if (this.outputStream == null) {
            throw new IllegalStateException("Cannot write a workbook with an uninitialized output stream. Was Transformer.setOutputStream() called?");
        }
        if (this.workbook == null) {
            throw new IllegalStateException("Cannot write an uninitialized workbook");
        }
        if (!this.isStreaming() && this.isEvaluateFormulas()) {
            this.workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
        if (this.isFullFormulaRecalculationOnOpening()) {
            this.workbook.setForceFormulaRecalculation(true);
        }
        this.workbook.write(this.outputStream);
    }

    public void dispose() {
        try {
            if (this.workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Throwable)e, "Error disposing streamed workbook");
        }
    }

    private List<CellData> readCommentsFromSheet(Sheet sheet, int rowNum) {
        ArrayList<CellData> commentDataCells = new ArrayList<CellData>();
        for (Map.Entry e : sheet.getCellComments().entrySet()) {
            Comment comment;
            if (((CellAddress)e.getKey()).getRow() != rowNum || (comment = (Comment)e.getValue()).getString() == null) continue;
            CellData cellData = new CellData(new CellRef(sheet.getSheetName(), ((CellAddress)e.getKey()).getRow(), ((CellAddress)e.getKey()).getColumn()));
            cellData.setCellComment(comment.getString().getString());
            commentDataCells.add(cellData);
        }
        commentDataCells.sort((a, b) -> a.getCol() - b.getCol());
        return commentDataCells;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public CellStyle getCellStyle(CellRef cellRef) {
        SheetData sheetData = (SheetData)this.sheetMap.get(cellRef.getSheetName());
        PoiCellData cellData = (PoiCellData)sheetData.getRowData(cellRef.getRow()).getCellData(cellRef.getCol());
        return cellData.getCellStyle();
    }

    public boolean deleteSheet(String sheetName) {
        if (super.deleteSheet(sheetName)) {
            int sheetIndex = this.workbook.getSheetIndex(sheetName);
            this.workbook.removeSheetAt(sheetIndex);
            return true;
        }
        this.getLogger().warn("Failed to find sheet '" + sheetName + "' in sheet map. Skipping the deletion.");
        return false;
    }

    public void setHidden(String sheetName, boolean hidden) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.workbook.setSheetHidden(sheetIndex, hidden);
    }

    public void updateRowHeight(String srcSheetName, int srcRowNum, String targetSheetName, int targetRowNum) {
        Row targetRow;
        if (this.isSXSSF) {
            return;
        }
        SheetData sheetData = (SheetData)this.sheetMap.get(srcSheetName);
        RowData rowData = sheetData.getRowData(srcRowNum);
        Sheet sheet = this.workbook.getSheet(targetSheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(targetSheetName);
        }
        if ((targetRow = sheet.getRow(targetRowNum)) == null) {
            targetRow = sheet.createRow(targetRowNum);
        }
        short srcHeight = rowData != null ? (short)rowData.getHeight() : sheet.getDefaultRowHeight();
        targetRow.setHeight(srcHeight);
    }

    public XSSFWorkbook getXSSFWorkbook() {
        if (this.workbook instanceof SXSSFWorkbook) {
            return ((SXSSFWorkbook)this.workbook).getXSSFWorkbook();
        }
        if (this.workbook instanceof XSSFWorkbook) {
            return (XSSFWorkbook)this.workbook;
        }
        return null;
    }

    public void adjustTableSize(CellRef ref, Size size) {
        XSSFWorkbook xwb = this.getXSSFWorkbook();
        if (size.getHeight() > 0 && xwb != null) {
            XSSFSheet sheet = xwb.getSheet(ref.getSheetName());
            if (sheet == null) {
                this.getLogger().error("Can not access sheet '" + ref.getSheetName() + "'");
            } else {
                for (XSSFTable table : sheet.getTables()) {
                    AreaRef areaRef = new AreaRef(table.getSheetName() + "!" + table.getCTTable().getRef());
                    if (!areaRef.contains(ref)) continue;
                    areaRef.getLastCellRef().setRow(ref.getRow() + size.getHeight() - 1);
                    table.getCTTable().setRef(areaRef.getFirstCellRef().toString(true) + ":" + areaRef.getLastCellRef().toString(true));
                }
            }
        }
    }
}

