/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.DomainAndResourcepartJid;
import org.jxmpp.jid.impl.DomainpartJid;
import org.jxmpp.jid.impl.LocalAndDomainpartJid;
import org.jxmpp.jid.impl.LocalDomainAndResourcepartJid;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class JidCreate {
    private static final Cache<String, Jid> JID_CACHE = new LruCache(100);
    private static final Cache<String, BareJid> BAREJID_CACHE = new LruCache(100);
    private static final Cache<String, FullJid> FULLJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainBareJid> DOMAINJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainFullJid> DOMAINRESOURCEJID_CACHE = new LruCache(100);

    public static Jid from(String localpart, String domainpart, String resource) throws XmppStringprepException {
        String jidString = XmppStringUtils.completeJidFrom((String)localpart, (String)domainpart, (String)resource);
        Jid jid = (Jid)JID_CACHE.get((Object)jidString);
        if (jid != null) {
            return jid;
        }
        if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        } else if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new LocalAndDomainpartJid(localpart, domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new DomainpartJid(domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new DomainAndResourcepartJid(domainpart, resource);
        } else {
            throw new IllegalArgumentException("Not a valid combination of localpart, domainpart and resource");
        }
        JID_CACHE.put((Object)jidString, (Object)jid);
        return jid;
    }

    public static Jid from(String jidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)jidString);
        String domainpart = XmppStringUtils.parseDomain((String)jidString);
        String resource = XmppStringUtils.parseResource((String)jidString);
        return JidCreate.from(localpart, domainpart, resource);
    }

    public static Jid fromUnescaped(String escapedJidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)escapedJidString);
        localpart = XmppStringUtils.escapeLocalpart((String)localpart);
        String domainpart = XmppStringUtils.parseDomain((String)escapedJidString);
        String resource = XmppStringUtils.parseResource((String)escapedJidString);
        return JidCreate.from(localpart, domainpart, resource);
    }

    public static BareJid bareFrom(String jid) throws XmppStringprepException {
        BareJid bareJid = (BareJid)BAREJID_CACHE.get((Object)jid);
        if (bareJid != null) {
            return bareJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        bareJid = new LocalAndDomainpartJid(localpart, domainpart);
        BAREJID_CACHE.put((Object)jid, (Object)bareJid);
        return bareJid;
    }

    public static FullJid fullFrom(String jid) throws XmppStringprepException {
        FullJid fullJid = (FullJid)FULLJID_CACHE.get((Object)jid);
        if (fullJid != null) {
            return fullJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        fullJid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        FULLJID_CACHE.put((Object)jid, (Object)fullJid);
        return fullJid;
    }

    public static DomainBareJid serverBareFrom(String jid) throws XmppStringprepException {
        DomainBareJid domainJid = (DomainBareJid)DOMAINJID_CACHE.get((Object)jid);
        if (domainJid != null) {
            return domainJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        domainJid = new DomainpartJid(domain);
        DOMAINJID_CACHE.put((Object)jid, (Object)domainJid);
        return domainJid;
    }

    public static DomainFullJid serverFullFrom(String jid) throws XmppStringprepException {
        DomainFullJid domainResourceJid = (DomainFullJid)DOMAINRESOURCEJID_CACHE.get((Object)jid);
        if (domainResourceJid != null) {
            return domainResourceJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        domainResourceJid = new DomainAndResourcepartJid(domain, resource);
        DOMAINRESOURCEJID_CACHE.put((Object)jid, (Object)domainResourceJid);
        return domainResourceJid;
    }
}

