/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid;

import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidWithLocalpart;
import org.jxmpp.jid.JidWithResource;

public abstract class AbstractJid
implements Jid {
    @Override
    public final boolean isBareOrFullJid() {
        return this.isBareJid() || this.isFullJid();
    }

    @Override
    public final boolean isBareJid() {
        return this instanceof BareJid;
    }

    @Override
    public final boolean isFullJid() {
        return this instanceof FullJid;
    }

    @Override
    public final boolean isDomainBareJid() {
        return this instanceof DomainBareJid;
    }

    @Override
    public final boolean isDomainFullJid() {
        return this instanceof DomainFullJid;
    }

    @Override
    public abstract boolean hasNoResource();

    @Override
    public final boolean hasResource() {
        return this instanceof JidWithResource;
    }

    @Override
    public final boolean hasLocalpart() {
        return this instanceof JidWithLocalpart;
    }

    @Override
    public final <T extends AbstractJid> T downcast() {
        return (T)this;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String getResourceOrNull() {
        return null;
    }

    @Override
    public String getLocalpartOrNull() {
        return null;
    }

    @Override
    public final boolean isParentOf(Jid jid) {
        FullJid fullJid = jid.asFullJidIfPossible();
        if (fullJid != null) {
            return this.isParentOf(fullJid);
        }
        BareJid bareJid = jid.asBareJidIfPossible();
        if (bareJid != null) {
            return this.isParentOf(bareJid);
        }
        DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
        if (domainFullJid != null) {
            return this.isParentOf(domainFullJid);
        }
        DomainBareJid domainBareJid = jid.asDomainBareJidIfPossible();
        if (domainBareJid != null) {
            return this.isParentOf(domainBareJid);
        }
        throw new AssertionError((Object)("Unkown JID class: " + jid.getClass().getName()));
    }
}

