/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidWithLocalpart;
import org.jxmpp.jid.JidWithResource;
import org.jxmpp.jid.impl.AbstractJid;
import org.jxmpp.jid.impl.DomainpartJid;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public final class LocalAndDomainpartJid
extends AbstractJid
implements BareJid {
    private static final long serialVersionUID = 1L;
    private final DomainBareJid domainBareJid;
    private final Localpart localpart;
    private String cache;
    private String unescapedCache;

    LocalAndDomainpartJid(String localpart, String domain) throws XmppStringprepException {
        this.domainBareJid = new DomainpartJid(domain);
        this.localpart = Localpart.from(localpart);
    }

    LocalAndDomainpartJid(Localpart localpart, Domainpart domain) {
        this.localpart = localpart;
        this.domainBareJid = new DomainpartJid(domain);
    }

    @Override
    public final Localpart getLocalpart() {
        return this.localpart;
    }

    @Override
    public String toString() {
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = this.getLocalpart().toString() + '@' + this.domainBareJid.toString();
        return this.cache;
    }

    @Override
    public String asUnescapedString() {
        if (this.unescapedCache != null) {
            return this.unescapedCache;
        }
        this.unescapedCache = XmppStringUtils.unescapeLocalpart((String)this.getLocalpart().toString()) + '@' + this.domainBareJid.toString();
        return this.unescapedCache;
    }

    @Override
    public BareJid asBareJidIfPossible() {
        return this;
    }

    @Override
    public FullJid asFullJidIfPossible() {
        return null;
    }

    @Override
    public DomainFullJid asDomainFullJidIfPossible() {
        return null;
    }

    @Override
    public boolean isParentOf(BareJid bareJid) {
        return this.domainBareJid.equals(bareJid.getDomain()) && this.localpart.equals(bareJid.getLocalpart());
    }

    @Override
    public boolean isParentOf(FullJid fullJid) {
        return this.isParentOf(fullJid.asBareJid());
    }

    @Override
    public boolean isParentOf(DomainBareJid domainBareJid) {
        return false;
    }

    @Override
    public boolean isParentOf(DomainFullJid domainFullJid) {
        return false;
    }

    @Override
    public DomainBareJid asDomainBareJid() {
        return this.domainBareJid;
    }

    @Override
    public Domainpart getDomain() {
        return this.domainBareJid.getDomain();
    }

    @Override
    public Jid withoutResource() {
        return this;
    }

    @Override
    public boolean hasNoResource() {
        return true;
    }

    @Override
    public JidWithLocalpart asJidWithLocalpartIfPossible() {
        return this;
    }

    @Override
    public JidWithResource asJidWithResourcepartIfPossible() {
        return null;
    }

    @Override
    public BareJid asBareJid() {
        return this;
    }

    @Override
    public Resourcepart getResourceOrNull() {
        return null;
    }

    @Override
    public Localpart getLocalpartOrNull() {
        return this.getLocalpart();
    }
}

