/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public class JidUtil {
    public static boolean isValidBareJid(CharSequence jid) {
        try {
            JidUtil.validateBareJid(jid);
        }
        catch (NotABareJidStringException | XmppStringprepException e) {
            return false;
        }
        return true;
    }

    public static BareJid validateBareJid(CharSequence jidcs) throws NotABareJidStringException, XmppStringprepException {
        String jid = jidcs.toString();
        int atIndex = jid.indexOf(64);
        if (atIndex == -1) {
            throw new NotABareJidStringException("'" + jid + "' does not contain a '@' character");
        }
        if (jid.indexOf(64, atIndex + 1) != -1) {
            throw new NotABareJidStringException("'" + jid + "' contains multiple '@' characters");
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        if (localpart.length() == 0) {
            throw new NotABareJidStringException("'" + jid + "' has empty localpart");
        }
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        if (domainpart.length() == 0) {
            throw new NotABareJidStringException("'" + jid + "' has empty domainpart");
        }
        return JidCreate.bareFrom(jid);
    }

    public static void filterBareJid(Collection<? extends Jid> in, Collection<BareJid> out) {
        for (Jid jid : in) {
            BareJid bareJid = jid.asBareJidIfPossible();
            if (bareJid == null) continue;
            out.add(bareJid);
        }
    }

    public static Set<BareJid> filterBareJidSet(Collection<? extends Jid> input) {
        HashSet<BareJid> res = new HashSet<BareJid>(input.size());
        JidUtil.filterBareJid(input, res);
        return res;
    }

    public static List<BareJid> filterBareJidList(Collection<? extends Jid> input) {
        ArrayList<BareJid> res = new ArrayList<BareJid>(input.size());
        JidUtil.filterBareJid(input, res);
        return res;
    }

    public static void filterFullJid(Collection<? extends Jid> in, Collection<FullJid> out) {
        for (Jid jid : in) {
            FullJid fullJid = jid.asFullJidIfPossible();
            if (fullJid == null) continue;
            out.add(fullJid);
        }
    }

    public static Set<FullJid> filterFullJidSet(Collection<? extends Jid> input) {
        HashSet<FullJid> res = new HashSet<FullJid>(input.size());
        JidUtil.filterFullJid(input, res);
        return res;
    }

    public static List<FullJid> filterFullJidList(Collection<? extends Jid> input) {
        ArrayList<FullJid> res = new ArrayList<FullJid>(input.size());
        JidUtil.filterFullJid(input, res);
        return res;
    }

    public static void filterDomainFullJid(Collection<? extends Jid> in, Collection<DomainFullJid> out) {
        for (Jid jid : in) {
            DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
            if (domainFullJid == null) continue;
            out.add(domainFullJid);
        }
    }

    public static Set<DomainFullJid> filterDomainFullJidSet(Collection<? extends Jid> input) {
        HashSet<DomainFullJid> res = new HashSet<DomainFullJid>(input.size());
        JidUtil.filterDomainFullJid(input, res);
        return res;
    }

    public static List<DomainFullJid> filterDomainFullJidList(Collection<? extends Jid> input) {
        ArrayList<DomainFullJid> res = new ArrayList<DomainFullJid>(input.size());
        JidUtil.filterDomainFullJid(input, res);
        return res;
    }

    public static Set<BareJid> bareJidSetFrom(Collection<? extends CharSequence> jidStrings) {
        HashSet<BareJid> res = new HashSet<BareJid>(jidStrings.size());
        JidUtil.bareJidsFrom(jidStrings, res, null);
        return res;
    }

    public static void bareJidsFrom(Collection<? extends CharSequence> jidStrings, Collection<BareJid> output, List<XmppStringprepException> exceptions) {
        for (CharSequence charSequence : jidStrings) {
            try {
                BareJid bareJid = JidCreate.bareFrom(charSequence);
                output.add(bareJid);
            }
            catch (XmppStringprepException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw new AssertionError((Object)e);
            }
        }
    }

    public static Set<Jid> jidSetFrom(String[] jids) {
        return JidUtil.jidSetFrom(Arrays.asList(jids));
    }

    public static Set<Jid> jidSetFrom(Collection<? extends CharSequence> jidStrings) {
        HashSet<Jid> res = new HashSet<Jid>(jidStrings.size());
        JidUtil.jidsFrom(jidStrings, res, null);
        return res;
    }

    public static void jidsFrom(Collection<? extends CharSequence> jidStrings, Collection<Jid> output, List<XmppStringprepException> exceptions) {
        for (CharSequence charSequence : jidStrings) {
            try {
                Jid jid = JidCreate.from(charSequence);
                output.add(jid);
            }
            catch (XmppStringprepException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw new AssertionError((Object)e);
            }
        }
    }

    public static List<String> toStringList(Collection<? extends Jid> jids) {
        ArrayList<String> res = new ArrayList<String>(jids.size());
        JidUtil.toStrings(jids, res);
        return res;
    }

    public static Set<String> toStringSet(Collection<? extends Jid> jids) {
        HashSet<String> res = new HashSet<String>(jids.size());
        JidUtil.toStrings(jids, res);
        return res;
    }

    public static void toStrings(Collection<? extends Jid> jids, Collection<? super String> jidStrings) {
        for (Jid jid : jids) {
            jidStrings.add(jid.toString());
        }
    }

    public static class NotABareJidStringException
    extends Exception {
        private static final long serialVersionUID = -1710386661031655082L;

        public NotABareJidStringException(String message) {
            super(message);
        }
    }
}

