/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.maven.plugin.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.RobotServer;
import org.kaazing.k3po.maven.plugin.internal.AbstractMojo;
import org.kaazing.k3po.maven.plugin.internal.logging.MavenLoggerFactory;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class StartMojo
extends AbstractMojo {
    @Parameter(defaultValue="true", property="maven.k3po.daemon")
    private boolean daemon;
    @Parameter(name="control", defaultValue="tcp://localhost:11642")
    private URI controlURI;
    @Parameter(defaultValue="src/test/scripts")
    private File scriptDir;
    @Parameter(defaultValue="false", property="maven.k3po.verbose")
    private boolean verbose;
    @Parameter(property="basedir")
    private File workingDirectory;

    public URI getControl() {
        return this.controlURI;
    }

    public void setControl(URI controlURI) {
        this.controlURI = controlURI;
    }

    @Override
    protected void executeImpl() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Log log = this.getLog();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)String.format("Setting System property \"user.dir\" to [%s]", this.workingDirectory.getAbsolutePath()));
            }
            System.setProperty("user.dir", this.workingDirectory.getAbsolutePath());
            ClassLoader testClassLoader = this.createTestClassLoader();
            RobotServer server = new RobotServer(this.getControl(), this.verbose, testClassLoader);
            Map pluginsAsMap = this.project.getBuild().getPluginsAsMap();
            Plugin plugin = (Plugin)pluginsAsMap.get("org.kaazing:k3po-maven-plugin");
            if (plugin != null) {
                for (Dependency dependency : plugin.getDependencies()) {
                    if (!this.project.getGroupId().equals(dependency.getGroupId()) || !this.project.getArtifactId().equals(dependency.getArtifactId()) || !this.project.getVersion().equals(dependency.getVersion())) continue;
                    Thread.currentThread().setContextClassLoader(testClassLoader);
                }
            }
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new MavenLoggerFactory(log));
            long checkpoint = System.currentTimeMillis();
            server.start();
            float duration = (float)(System.currentTimeMillis() - checkpoint) / 1000.0f;
            if (log.isDebugEnabled()) {
                String version;
                String string = version = plugin != null ? plugin.getVersion() : "unknown";
                if (!this.daemon) {
                    log.debug((CharSequence)String.format("K3PO [%s] started in %.3fsec (CTRL+C to stop)", version, Float.valueOf(duration)));
                } else {
                    log.debug((CharSequence)String.format("K3PO [%s] started in %.3fsec", version, Float.valueOf(duration)));
                }
            } else if (!this.daemon) {
                log.info((CharSequence)"K3PO started (CTRL+C to stop)");
            } else {
                log.info((CharSequence)"K3PO started");
            }
            this.setServer(server);
            if (!this.daemon) {
                server.join();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("K3PO failed to start", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private ClassLoader createTestClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        LinkedList<URL> scriptPath = new LinkedList<URL>();
        if (this.scriptDir != null) {
            scriptPath.add(this.scriptDir.getAbsoluteFile().toURI().toURL());
        }
        for (Object scriptPathEntry : this.project.getTestClasspathElements()) {
            URI scriptPathURI = new File(scriptPathEntry.toString()).getAbsoluteFile().toURI();
            scriptPath.add(scriptPathURI.toURL());
        }
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        return new URLClassLoader(scriptPath.toArray(new URL[scriptPath.size()]), parent);
    }
}

