/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.maven.plugin.internal;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.kaazing.k3po.driver.internal.RobotServer;
import org.kaazing.k3po.maven.plugin.internal.AbstractMojo;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class StopMojo
extends AbstractMojo {
    @Override
    protected void executeImpl() throws MojoExecutionException {
        RobotServer server = this.getServer();
        if (server == null) {
            this.getLog().error((CharSequence)String.format("K3PO not running", new Object[0]));
        } else {
            try {
                long checkpoint = System.currentTimeMillis();
                server.stop();
                float duration = (float)(System.currentTimeMillis() - checkpoint) / 1000.0f;
                this.getLog().debug((CharSequence)String.format("K3PO [%08x] stopped in %.3fsec", System.identityHashCode(server), Float.valueOf(duration)));
                this.setServer(null);
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("K3PO [%08x] failed to stop", System.identityHashCode(server)), e);
            }
        }
    }
}

