/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.behavior.Configuration;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgress;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.CompletionHandler;
import org.kaazing.k3po.driver.internal.behavior.parser.Parser;
import org.kaazing.k3po.driver.internal.behavior.parser.ScriptValidator;
import org.kaazing.k3po.driver.internal.behavior.visitor.GenerateConfigurationVisitor;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.netty.channel.CompositeChannelFuture;
import org.kaazing.k3po.driver.internal.resolver.ClientBootstrapResolver;
import org.kaazing.k3po.driver.internal.resolver.ServerBootstrapResolver;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstScriptNode;

public class Robot {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(Robot.class);
    private final List<ChannelFuture> bindFutures = new ArrayList<ChannelFuture>();
    private final List<ChannelFuture> connectFutures = new ArrayList<ChannelFuture>();
    private final Channel channel = new DefaultLocalClientChannelFactory().newChannel(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new SimpleChannelHandler()}));
    private final ChannelFuture startedFuture = Channels.future((Channel)this.channel);
    private final ChannelFuture abortedFuture = Channels.future((Channel)this.channel);
    private final ChannelFuture finishedFuture = Channels.future((Channel)this.channel);
    private final ChannelFuture disposedFuture = Channels.future((Channel)this.channel);
    private final DefaultChannelGroup closeableChannels = new DefaultChannelGroup();
    private Configuration configuration;
    private ChannelFuture preparedFuture;
    private final ChannelAddressFactory addressFactory;
    private final BootstrapFactory bootstrapFactory;
    private ScriptProgress progress;
    private final ChannelHandler closeOnExceptionHandler = new CloseOnExceptionHandler();
    private final ConcurrentMap<String, Barrier> barriersByName = new ConcurrentHashMap<String, Barrier>();

    public Robot() {
        this.addressFactory = ChannelAddressFactory.newChannelAddressFactory();
        this.bootstrapFactory = BootstrapFactory.newBootstrapFactory(Collections.singletonMap(ChannelAddressFactory.class, this.addressFactory));
        ChannelFutureListener stopConfigurationListener = this.createStopConfigurationListener();
        this.abortedFuture.addListener(stopConfigurationListener);
        this.finishedFuture.addListener(stopConfigurationListener);
    }

    public ChannelFuture getPreparedFuture() {
        return this.preparedFuture;
    }

    public ChannelFuture getStartedFuture() {
        return this.startedFuture;
    }

    public ChannelFuture getDisposedFuture() {
        return this.disposedFuture;
    }

    public ChannelFuture prepare(String expectedScript) throws Exception {
        if (this.preparedFuture != null) {
            throw new IllegalStateException("Script already prepared");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Expected script:\n" + expectedScript);
        }
        Parser parser = new Parser();
        AstScriptNode scriptAST = parser.parse(expectedScript);
        ScriptValidator validator = new ScriptValidator();
        validator.validate(scriptAST);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsed script:\n" + scriptAST);
        }
        RegionInfo scriptInfo = scriptAST.getRegionInfo();
        this.progress = new ScriptProgress(scriptInfo, expectedScript);
        GenerateConfigurationVisitor visitor = new GenerateConfigurationVisitor(this.bootstrapFactory, this.addressFactory);
        this.configuration = (Configuration)scriptAST.accept((AstNode.Visitor)visitor, (Object)new GenerateConfigurationVisitor.State(this.barriersByName));
        this.preparedFuture = this.prepareConfiguration();
        return this.preparedFuture;
    }

    ChannelFuture prepareAndStart(String script) throws Exception {
        ChannelFuture preparedFuture = this.prepare(script);
        preparedFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Robot.this.start();
            }
        });
        return this.startedFuture;
    }

    public ChannelFuture start() throws Exception {
        if (this.preparedFuture == null || !this.preparedFuture.isDone()) {
            throw new IllegalStateException("Script has not been prepared or is still preparing");
        }
        if (this.startedFuture.isDone()) {
            throw new IllegalStateException("Script has already been started");
        }
        this.preparedFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    Robot.this.startConfiguration();
                    Robot.this.startedFuture.setSuccess();
                }
                catch (Exception ex) {
                    Robot.this.startedFuture.setFailure((Throwable)ex);
                }
            }
        });
        return this.startedFuture;
    }

    public ChannelFuture abort() {
        this.abortedFuture.setSuccess();
        return this.finishedFuture;
    }

    public ChannelFuture finish() {
        return this.finishedFuture;
    }

    public String getObservedScript() {
        return this.progress != null ? this.progress.getObservedScript() : null;
    }

    public ChannelFuture dispose() {
        if (this.preparedFuture == null) {
            this.bootstrapFactory.shutdown();
            this.bootstrapFactory.releaseExternalResources();
            this.disposedFuture.setSuccess();
        } else if (!this.disposedFuture.isDone()) {
            ChannelFuture future = this.abort();
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Robot.this.closeableChannels.close().awaitUninterruptibly(30L, TimeUnit.SECONDS);
                            try {
                                Robot.this.bootstrapFactory.shutdown();
                                Robot.this.bootstrapFactory.releaseExternalResources();
                                for (AutoCloseable resource : Robot.this.configuration.getResources()) {
                                    try {
                                        resource.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                Robot.this.disposedFuture.setSuccess();
                            }
                            catch (Exception e) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.error("Caught exception releasing resources", (Throwable)e);
                                }
                                Robot.this.disposedFuture.setFailure((Throwable)e);
                            }
                        }
                    }).start();
                }
            });
        }
        return this.disposedFuture;
    }

    private ChannelFuture prepareConfiguration() throws Exception {
        ArrayList<ChannelFuture> completionFutures = new ArrayList<ChannelFuture>();
        ChannelFutureListener streamCompletionListener = this.createStreamCompletionListener();
        for (ChannelPipeline pipeline : this.configuration.getClientAndServerPipelines()) {
            CompletionHandler completionHandler = (CompletionHandler)pipeline.get(CompletionHandler.class);
            ChannelFuture completionFuture = completionHandler.getHandlerFuture();
            completionFutures.add(completionFuture);
            completionFuture.addListener(streamCompletionListener);
        }
        CompositeChannelFuture executionFuture = new CompositeChannelFuture(this.channel, completionFutures);
        ChannelFutureListener executionListener = this.createScriptCompletionListener();
        executionFuture.addListener(executionListener);
        return this.prepareServers();
    }

    private ChannelFuture prepareServers() throws Exception {
        for (final ServerBootstrapResolver serverResolver : this.configuration.getServerResolvers()) {
            ServerBootstrap server = serverResolver.resolve();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Binding to address " + server.getOption("localAddress"));
            }
            server.setParentHandler((ChannelHandler)new SimpleChannelHandler(){

                public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                    super.channelBound(ctx, e);
                    this.unbindLastStreamIfNotUdp(serverResolver, e.getChannel());
                }

                public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                    Robot.this.closeableChannels.add(e.getChildChannel());
                    this.unbindLastStreamIfNotUdp(serverResolver, e.getChannel());
                }

                public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
                    Channel channel = ctx.getChannel();
                    channel.close();
                }

                private void unbindLastStreamIfNotUdp(ServerBootstrapResolver serverResolver2, Channel server) {
                    if (!serverResolver2.canAccept() && !(server instanceof UdpServerChannel)) {
                        server.unbind();
                    }
                }
            });
            ChannelFuture bindFuture = server.bindAsync();
            this.closeableChannels.add(bindFuture.getChannel());
            this.bindFutures.add(bindFuture);
            RegionInfo regionInfo = (RegionInfo)server.getOption("regionInfo");
            bindFuture.addListener(this.createBindCompleteListener(regionInfo, serverResolver.getNotifyBarrier()));
        }
        return new CompositeChannelFuture<ChannelFuture>(this.channel, this.bindFutures);
    }

    private void startConfiguration() throws Exception {
        for (final ClientBootstrapResolver clientResolver : this.configuration.getClientResolvers()) {
            Barrier awaitBarrier = clientResolver.getAwaitBarrier();
            if (awaitBarrier != null) {
                awaitBarrier.getFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        Robot.this.connectClient(clientResolver);
                    }
                });
                continue;
            }
            this.connectClient(clientResolver);
        }
    }

    private void connectClient(ClientBootstrapResolver clientResolver) throws Exception {
        ClientBootstrap client = clientResolver.resolve();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[id:           ] connect " + client.getOption("remoteAddress"));
        }
        final ChannelFuture connectFuture = client.connect();
        this.connectFutures.add(connectFuture);
        connectFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Robot.this.closeableChannels.add(connectFuture.getChannel());
                }
            }
        });
    }

    private void stopConfiguration() throws Exception {
        if (this.configuration == null) {
            if (this.progress == null) {
                this.progress = new ScriptProgress(RegionInfo.newSequential((int)0, (int)0), "");
            }
            RegionInfo scriptInfo = this.progress.getScriptInfo();
            this.progress.addScriptFailure(scriptInfo);
        } else {
            for (ServerBootstrapResolver serverResolver : this.configuration.getServerResolvers()) {
                try {
                    ServerBootstrap server = serverResolver.resolve();
                    server.setPipelineFactory(Channels.pipelineFactory((ChannelPipeline)Channels.pipeline((ChannelHandler[])new ChannelHandler[]{this.closeOnExceptionHandler})));
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Exception caught while trying to stop server pipelies", (Throwable)e);
                }
            }
            for (ClientBootstrapResolver clientResolver : this.configuration.getClientResolvers()) {
                try {
                    ClientBootstrap client = clientResolver.resolve();
                    client.setPipelineFactory(Channels.pipelineFactory((ChannelPipeline)Channels.pipeline((ChannelHandler[])new ChannelHandler[]{this.closeOnExceptionHandler})));
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Exception caught while trying to stop client pipelies", (Throwable)e);
                }
            }
            for (ChannelPipeline pipeline : this.configuration.getClientAndServerPipelines()) {
                this.stopStream(pipeline);
            }
            for (ChannelFuture bindFuture : this.bindFutures) {
                bindFuture.cancel();
            }
            for (ChannelFuture connectFuture : this.connectFutures) {
                if (!connectFuture.cancel()) continue;
                LOGGER.debug("Cancelled connect future: " + connectFuture.getChannel().getRemoteAddress());
            }
        }
    }

    private void stopStream(final ChannelPipeline pipeline) {
        if (pipeline.isAttached()) {
            pipeline.execute(new Runnable(){

                @Override
                public void run() {
                    Robot.this.stopStreamAligned(pipeline);
                }
            });
        } else {
            this.stopStreamAligned(pipeline);
        }
    }

    private void stopStreamAligned(ChannelPipeline pipeline) {
        LOGGER.debug("Stopping pipeline");
        for (ChannelHandler handler : pipeline.toMap().values()) {
            if (LOGGER.isDebugEnabled()) {
                Channel channel = pipeline.getChannel();
                int id = channel != null ? channel.getId() : 0;
                LOGGER.debug(String.format("[id: 0x%08x] %s", id, handler));
            }
            pipeline.remove(handler);
        }
        if (pipeline.getContext(this.closeOnExceptionHandler) == null) {
            pipeline.addLast("closeOnException", this.closeOnExceptionHandler);
        }
    }

    private ChannelFutureListener createBindCompleteListener(final RegionInfo regionInfo, final Barrier notifyBarrier) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture bindFuture) throws Exception {
                Channel boundChannel = bindFuture.getChannel();
                SocketAddress localAddress = boundChannel.getLocalAddress();
                if (bindFuture.isSuccess()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Successfully bound to " + localAddress);
                    }
                    if (notifyBarrier != null) {
                        ChannelFuture barrierFuture = notifyBarrier.getFuture();
                        barrierFuture.setSuccess();
                    }
                } else {
                    Throwable cause = bindFuture.getCause();
                    String message = String.format("accept failed: %s", cause.getMessage());
                    Robot.this.progress.addScriptFailure(regionInfo, message);
                    List<ChannelPipeline> acceptedPipelines = Robot.this.configuration.getServerPipelines(regionInfo);
                    for (ChannelPipeline acceptedPipeline : acceptedPipelines) {
                        Robot.this.stopStream(acceptedPipeline);
                    }
                }
            }
        };
    }

    private ChannelFutureListener createStreamCompletionListener() {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture completionFuture) throws Exception {
                if (!completionFuture.isSuccess()) {
                    Throwable cause = completionFuture.getCause();
                    if (cause instanceof ScriptProgressException) {
                        ScriptProgressException exception = (ScriptProgressException)cause;
                        Robot.this.progress.addScriptFailure(exception.getRegionInfo(), exception.getMessage());
                    } else {
                        LOGGER.warn("Unexpected exception", cause);
                    }
                }
            }
        };
    }

    private ChannelFutureListener createScriptCompletionListener() {
        ChannelFutureListener executionListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (LOGGER.isDebugEnabled()) {
                    String observedScript = Robot.this.progress.getObservedScript();
                    LOGGER.debug("Observed script:\n" + observedScript);
                }
                if (Robot.this.abortedFuture.isDone()) {
                    Robot.this.finishedFuture.setSuccess();
                } else {
                    Robot.this.finishedFuture.setSuccess();
                }
            }
        };
        return executionListener;
    }

    private ChannelFutureListener createStopConfigurationListener() {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Robot.this.stopConfiguration();
            }
        };
    }

    public Map<String, Barrier> getBarriersByName() {
        return this.barriersByName;
    }

    public void notifyBarrier(String barrierName) throws Exception {
        Barrier barrier = (Barrier)this.barriersByName.get(barrierName);
        if (barrier == null) {
            throw new Exception("Can not notify a barrier that does not exist in the script: " + barrierName);
        }
        barrier.getFuture().setSuccess();
    }

    public ChannelFuture awaitBarrier(String barrierName) throws Exception {
        Barrier barrier = (Barrier)this.barriersByName.get(barrierName);
        if (barrier == null) {
            throw new Exception("Can not notify a barrier that does not exist in the script: " + barrierName);
        }
        return barrier.getFuture();
    }

    @ChannelHandler.Sharable
    private static final class CloseOnExceptionHandler
    extends SimpleChannelHandler {
        private CloseOnExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (Boolean.TRUE != ctx.getAttachment()) {
                ctx.setAttachment((Object)Boolean.TRUE);
                Channel channel = ctx.getChannel();
                channel.close();
            } else {
                super.exceptionCaught(ctx, e);
            }
        }

        public String toString() {
            return "close-on-exception";
        }
    }
}

