/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jboss.netty.channel.ChannelHandler;
import org.kaazing.k3po.driver.internal.behavior.BehaviorSystemSpi;
import org.kaazing.k3po.driver.internal.behavior.ReadConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;

public final class BehaviorSystem {
    private final Map<TypeInfo<?>, ReadOptionFactory> readOptions;
    private final Map<TypeInfo<?>, WriteOptionFactory> writeOptions;
    private final Map<StructuredTypeInfo, ReadConfigFactory> readConfigs;
    private final Map<StructuredTypeInfo, WriteConfigFactory> writeConfigs;

    private BehaviorSystem(Iterable<BehaviorSystemSpi> behaviorSystems) {
        IdentityHashMap readOptions = new IdentityHashMap();
        IdentityHashMap writeOptions = new IdentityHashMap();
        IdentityHashMap<StructuredTypeInfo, ReadConfigFactory> readConfigs = new IdentityHashMap<StructuredTypeInfo, ReadConfigFactory>();
        IdentityHashMap<StructuredTypeInfo, WriteConfigFactory> writeConfigs = new IdentityHashMap<StructuredTypeInfo, WriteConfigFactory>();
        for (BehaviorSystemSpi behaviorSystem : behaviorSystems) {
            for (TypeInfo<?> optionType : behaviorSystem.getReadOptionTypes()) {
                readOptions.put(optionType, behaviorSystem.readOptionFactory(optionType));
            }
            for (TypeInfo<?> optionType : behaviorSystem.getWriteOptionTypes()) {
                writeOptions.put(optionType, behaviorSystem.writeOptionFactory(optionType));
            }
            for (StructuredTypeInfo configType : behaviorSystem.getReadConfigTypes()) {
                readConfigs.put(configType, behaviorSystem.readConfigFactory(configType));
            }
            for (StructuredTypeInfo configType : behaviorSystem.getWriteConfigTypes()) {
                writeConfigs.put(configType, behaviorSystem.writeConfigFactory(configType));
            }
        }
        this.readOptions = Collections.unmodifiableMap(readOptions);
        this.writeOptions = Collections.unmodifiableMap(writeOptions);
        this.readConfigs = Collections.unmodifiableMap(readConfigs);
        this.writeConfigs = Collections.unmodifiableMap(writeConfigs);
    }

    public ChannelHandler newReadOptionHandler(AstReadOptionNode node) {
        TypeInfo optionType = node.getOptionType();
        ReadOptionFactory factory = this.readOptions.getOrDefault(optionType, n -> null);
        return factory.newHandler(node);
    }

    public ChannelHandler newWriteOptionHandler(AstWriteOptionNode node) {
        TypeInfo optionType = node.getOptionType();
        WriteOptionFactory factory = this.writeOptions.getOrDefault(optionType, n -> null);
        return factory.newHandler(node);
    }

    public ChannelHandler newReadConfigHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        StructuredTypeInfo type = node.getType();
        ReadConfigFactory factory = this.readConfigs.getOrDefault(type, (n, f) -> null);
        return factory.newHandler(node, decoderFactory);
    }

    public ChannelHandler newWriteConfigHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        WriteConfigFactory factory = this.writeConfigs.getOrDefault(type, (n, f) -> null);
        return factory.newHandler(node, encoderFactory);
    }

    public static final BehaviorSystem newInstance() {
        return new BehaviorSystem(ServiceLoader.load(BehaviorSystemSpi.class));
    }
}

