/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kaazing.k3po.driver.internal.behavior.BehaviorSystemSpi;
import org.kaazing.k3po.driver.internal.behavior.ReadConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.command.file.ReadOptionFileOffsetHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.command.file.WriteOptionFileOffsetHandler;
import org.kaazing.k3po.driver.internal.types.FileTypeSystem;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralTextValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;

public class FileBehaviorSystem
implements BehaviorSystemSpi {
    private final Map<TypeInfo<?>, ReadOptionFactory> readOptionFactories;
    private final Map<TypeInfo<?>, WriteOptionFactory> writeOptionFactories;
    private final Map<StructuredTypeInfo, ReadConfigFactory> readConfigFactories;
    private final Map<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories;

    public FileBehaviorSystem() {
        LinkedHashMap<TypeInfo<Long>, ReadOptionFactory> readOptionFactories = new LinkedHashMap<TypeInfo<Long>, ReadOptionFactory>();
        readOptionFactories.put(FileTypeSystem.OPTION_OFFSET, FileBehaviorSystem::newReadFileOffsetHandler);
        this.readOptionFactories = Collections.unmodifiableMap(readOptionFactories);
        LinkedHashMap<TypeInfo<Long>, WriteOptionFactory> writeOptionFactories = new LinkedHashMap<TypeInfo<Long>, WriteOptionFactory>();
        writeOptionFactories.put(FileTypeSystem.OPTION_OFFSET, FileBehaviorSystem::newWriteFileOffsetHandler);
        this.writeOptionFactories = Collections.unmodifiableMap(writeOptionFactories);
        this.readConfigFactories = Collections.emptyMap();
        this.writeConfigFactories = Collections.emptyMap();
    }

    @Override
    public Set<StructuredTypeInfo> getReadConfigTypes() {
        return this.readConfigFactories.keySet();
    }

    @Override
    public Set<StructuredTypeInfo> getWriteConfigTypes() {
        return this.writeConfigFactories.keySet();
    }

    @Override
    public ReadConfigFactory readConfigFactory(StructuredTypeInfo configType) {
        return this.readConfigFactories.get(configType);
    }

    @Override
    public WriteConfigFactory writeConfigFactory(StructuredTypeInfo configType) {
        return this.writeConfigFactories.get(configType);
    }

    @Override
    public Set<TypeInfo<?>> getReadOptionTypes() {
        return this.readOptionFactories.keySet();
    }

    @Override
    public Set<TypeInfo<?>> getWriteOptionTypes() {
        return this.writeOptionFactories.keySet();
    }

    @Override
    public ReadOptionFactory readOptionFactory(TypeInfo<?> optionType) {
        return this.readOptionFactories.get(optionType);
    }

    @Override
    public WriteOptionFactory writeOptionFactory(TypeInfo<?> optionType) {
        return this.writeOptionFactories.get(optionType);
    }

    private static ReadOptionFileOffsetHandler newReadFileOffsetHandler(AstReadOptionNode node) {
        AstLiteralTextValue offsetValue = (AstLiteralTextValue)node.getOptionValue();
        int offset = Integer.parseInt(offsetValue.getValue());
        ReadOptionFileOffsetHandler handler = new ReadOptionFileOffsetHandler(offset);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteOptionFileOffsetHandler newWriteFileOffsetHandler(AstWriteOptionNode node) {
        AstLiteralTextValue offsetValue = (AstLiteralTextValue)node.getOptionValue();
        int offset = Integer.parseInt(offsetValue.getValue());
        WriteOptionFileOffsetHandler handler = new WriteOptionFileOffsetHandler(offset);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }
}

