/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jboss.netty.channel.ChannelHandler;
import org.kaazing.k3po.driver.internal.behavior.BehaviorSystemSpi;
import org.kaazing.k3po.driver.internal.behavior.ReadConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpContentLengthEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpHeaderDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpHeaderEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpHeaderMissingDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpHostEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpMethodDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpMethodEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpParameterDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpParameterEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpRequestFormEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpStatusDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpStatusEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpTrailerDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpTrailerEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpVersionDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.HttpVersionEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.ReadConfigHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.command.WriteConfigHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.event.http.ReadHttpTrailersHandler;
import org.kaazing.k3po.driver.internal.types.HttpTypeSystem;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExactTextMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralTextValue;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;

public class HttpBehaviorSystem
implements BehaviorSystemSpi {
    private final Map<TypeInfo<?>, ReadOptionFactory> readOptionFactories = Collections.singletonMap(HttpTypeSystem.OPTION_CHUNK_EXT, HttpBehaviorSystem::newReadHttpChunkExtHandler);
    private final Map<TypeInfo<?>, WriteOptionFactory> writeOptionFactories = Collections.singletonMap(HttpTypeSystem.OPTION_CHUNK_EXT, HttpBehaviorSystem::newWriteHttpChunkExtHandler);
    private final Map<StructuredTypeInfo, ReadConfigFactory> readConfigFactories;
    private final Map<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories;

    public HttpBehaviorSystem() {
        LinkedHashMap<StructuredTypeInfo, ReadConfigFactory> readConfigFactories = new LinkedHashMap<StructuredTypeInfo, ReadConfigFactory>();
        readConfigFactories.put(HttpTypeSystem.CONFIG_METHOD, HttpBehaviorSystem::newReadHttpMethodHandler);
        readConfigFactories.put(HttpTypeSystem.CONFIG_HEADER, HttpBehaviorSystem::newReadHttpHeaderHandler);
        readConfigFactories.put(HttpTypeSystem.CONFIG_PARAMETER, HttpBehaviorSystem::newReadHttpParameterHandler);
        readConfigFactories.put(HttpTypeSystem.CONFIG_VERSION, HttpBehaviorSystem::newReadHttpVersionHandler);
        readConfigFactories.put(HttpTypeSystem.CONFIG_STATUS, HttpBehaviorSystem::newReadHttpStatusHandler);
        readConfigFactories.put(HttpTypeSystem.CONFIG_TRAILER, HttpBehaviorSystem::newReadHttpTrailerHandler);
        this.readConfigFactories = Collections.unmodifiableMap(readConfigFactories);
        LinkedHashMap<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories = new LinkedHashMap<StructuredTypeInfo, WriteConfigFactory>();
        writeConfigFactories.put(HttpTypeSystem.CONFIG_REQUEST, HttpBehaviorSystem::newWriteHttpRequestHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_HOST, HttpBehaviorSystem::newWriteHttpHostHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_CONTENT_LENGTH, HttpBehaviorSystem::newWriteHttpContentLengthHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_METHOD, HttpBehaviorSystem::newWriteHttpMethodHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_HEADER, HttpBehaviorSystem::newWriteHttpHeaderHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_PARAMETER, HttpBehaviorSystem::newWriteHttpParameterHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_VERSION, HttpBehaviorSystem::newWriteHttpVersionHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_STATUS, HttpBehaviorSystem::newWriteHttpStatusHandler);
        writeConfigFactories.put(HttpTypeSystem.CONFIG_TRAILER, HttpBehaviorSystem::newWriteHttpTrailerHandler);
        this.writeConfigFactories = Collections.unmodifiableMap(writeConfigFactories);
    }

    @Override
    public Set<StructuredTypeInfo> getReadConfigTypes() {
        return this.readConfigFactories.keySet();
    }

    @Override
    public Set<StructuredTypeInfo> getWriteConfigTypes() {
        return this.writeConfigFactories.keySet();
    }

    @Override
    public ReadConfigFactory readConfigFactory(StructuredTypeInfo configType) {
        return this.readConfigFactories.get(configType);
    }

    @Override
    public WriteConfigFactory writeConfigFactory(StructuredTypeInfo configType) {
        return this.writeConfigFactories.get(configType);
    }

    @Override
    public Set<TypeInfo<?>> getReadOptionTypes() {
        return this.readOptionFactories.keySet();
    }

    @Override
    public Set<TypeInfo<?>> getWriteOptionTypes() {
        return this.writeOptionFactories.keySet();
    }

    @Override
    public ReadOptionFactory readOptionFactory(TypeInfo<?> optionType) {
        return this.readOptionFactories.get(optionType);
    }

    @Override
    public WriteOptionFactory writeOptionFactory(TypeInfo<?> optionType) {
        return this.writeOptionFactories.get(optionType);
    }

    private static ChannelHandler newReadHttpChunkExtHandler(AstReadOptionNode node) {
        throw new UnsupportedOperationException("HttpMessageDecoder and DefaultHttpChunk do not support chunkExtensions in Netty 3.9, see https://github.com/k3po/k3po/issues/313, support for chunk extensions is thus not yet added");
    }

    private static ChannelHandler newWriteHttpChunkExtHandler(AstWriteOptionNode node) {
        throw new UnsupportedOperationException("HttpMessageDecoder and DefaultHttpChunk do not support chunkExtensions in Netty 3.9, see https://github.com/k3po/k3po/issues/313, support for chunk extensions is thus not yet added");
    }

    private static ReadHttpTrailersHandler newReadHttpTrailerHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstExactTextMatcher name = (AstExactTextMatcher)node.getMatcher("name");
        ArrayList<MessageDecoder> valueDecoders = new ArrayList<MessageDecoder>();
        for (AstValueMatcher matcher : node.getMatchers()) {
            valueDecoders.add(decoderFactory.apply(matcher));
        }
        HttpTrailerDecoder decoder = new HttpTrailerDecoder(name.getValue(), valueDecoders);
        decoder.setRegionInfo(node.getRegionInfo());
        ReadHttpTrailersHandler handler = new ReadHttpTrailersHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadConfigHandler newReadHttpStatusHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstValueMatcher code = node.getMatcher("code");
        AstValueMatcher reason = node.getMatcher("reason");
        MessageDecoder codeDecoder = decoderFactory.apply(code);
        MessageDecoder reasonDecoder = decoderFactory.apply(reason);
        HttpStatusDecoder decoder = new HttpStatusDecoder(codeDecoder, reasonDecoder);
        ReadConfigHandler handler = new ReadConfigHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadConfigHandler newReadHttpVersionHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstValueMatcher version = node.getMatcher();
        MessageDecoder versionDecoder = decoderFactory.apply(version);
        HttpVersionDecoder decoder = new HttpVersionDecoder(versionDecoder);
        ReadConfigHandler handler = new ReadConfigHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadConfigHandler newReadHttpParameterHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstExactTextMatcher name = (AstExactTextMatcher)node.getMatcher("name");
        Objects.requireNonNull(name);
        ArrayList<MessageDecoder> valueDecoders = new ArrayList<MessageDecoder>();
        for (AstValueMatcher matcher : node.getMatchers()) {
            valueDecoders.add(decoderFactory.apply(matcher));
        }
        HttpParameterDecoder decoder = new HttpParameterDecoder(name.getValue(), valueDecoders);
        decoder.setRegionInfo(node.getRegionInfo());
        ReadConfigHandler handler = new ReadConfigHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadConfigHandler newReadHttpHeaderHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstExactTextMatcher name = (AstExactTextMatcher)node.getMatcher("name");
        Objects.requireNonNull(name);
        if (node.isMissing()) {
            HttpHeaderMissingDecoder decoder = new HttpHeaderMissingDecoder(name.getValue());
            decoder.setRegionInfo(node.getRegionInfo());
            ReadConfigHandler handler = new ReadConfigHandler(decoder);
            handler.setRegionInfo(node.getRegionInfo());
            return handler;
        }
        ArrayList<MessageDecoder> valueDecoders = new ArrayList<MessageDecoder>();
        for (AstValueMatcher matcher : node.getMatchers()) {
            valueDecoders.add(decoderFactory.apply(matcher));
        }
        HttpHeaderDecoder decoder = new HttpHeaderDecoder(name.getValue(), valueDecoders);
        decoder.setRegionInfo(node.getRegionInfo());
        ReadConfigHandler handler = new ReadConfigHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadConfigHandler newReadHttpMethodHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        AstValueMatcher methodName = node.getMatcher();
        Objects.requireNonNull(methodName);
        MessageDecoder methodValueDecoder = decoderFactory.apply(methodName);
        HttpMethodDecoder decoder = new HttpMethodDecoder(methodValueDecoder);
        ReadConfigHandler handler = new ReadConfigHandler(decoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpTrailerHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue name = node.getValue("name");
        MessageEncoder nameEncoder = encoderFactory.apply(name);
        ArrayList<MessageEncoder> valueEncoders = new ArrayList<MessageEncoder>();
        for (AstValue value : node.getValues()) {
            valueEncoders.add(encoderFactory.apply(value));
        }
        WriteConfigHandler handler = new WriteConfigHandler(new HttpTrailerEncoder(nameEncoder, valueEncoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpStatusHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue code = node.getValue("code");
        AstValue reason = node.getValue("reason");
        MessageEncoder codeEncoder = encoderFactory.apply(code);
        MessageEncoder reasonEncoder = encoderFactory.apply(reason);
        WriteConfigHandler handler = new WriteConfigHandler(new HttpStatusEncoder(codeEncoder, reasonEncoder));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpVersionHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue version = node.getValue();
        MessageEncoder versionEncoder = encoderFactory.apply(version);
        WriteConfigHandler handler = new WriteConfigHandler(new HttpVersionEncoder(versionEncoder));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpParameterHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue name = node.getValue("name");
        MessageEncoder nameEncoder = encoderFactory.apply(name);
        ArrayList<MessageEncoder> valueEncoders = new ArrayList<MessageEncoder>();
        for (AstValue value : node.getValues()) {
            valueEncoders.add(encoderFactory.apply(value));
        }
        WriteConfigHandler handler = new WriteConfigHandler(new HttpParameterEncoder(nameEncoder, valueEncoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpMethodHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue methodName = node.getValue();
        Objects.requireNonNull(methodName);
        MessageEncoder methodEncoder = encoderFactory.apply(methodName);
        WriteConfigHandler handler = new WriteConfigHandler(new HttpMethodEncoder(methodEncoder));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpHostHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        WriteConfigHandler handler = new WriteConfigHandler(new HttpHostEncoder());
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpContentLengthHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        WriteConfigHandler handler = new WriteConfigHandler(new HttpContentLengthEncoder());
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpHeaderHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstValue name = node.getValue("name");
        MessageEncoder nameEncoder = encoderFactory.apply(name);
        ArrayList<MessageEncoder> valueEncoders = new ArrayList<MessageEncoder>();
        for (AstValue value : node.getValues()) {
            valueEncoders.add(encoderFactory.apply(value));
        }
        WriteConfigHandler handler = new WriteConfigHandler(new HttpHeaderEncoder(nameEncoder, valueEncoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteHttpRequestHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        AstLiteralTextValue form = (AstLiteralTextValue)node.getValue();
        MessageEncoder formEncoder = encoderFactory.apply((AstValue<?>)form);
        WriteConfigHandler handler = new WriteConfigHandler(new HttpRequestFormEncoder(formEncoder));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }
}

