/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.barrier;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.behavior.handler.barrier.AbstractBarrierHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.prepare.PreparationEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelFutureListeners;

public class AwaitBarrierUpstreamHandler
extends AbstractBarrierHandler
implements ChannelUpstreamHandler {
    private Queue<ChannelEvent> queue;

    public AwaitBarrierUpstreamHandler(Barrier barrier) {
        super(barrier);
    }

    @Override
    public void prepareRequested(final ChannelHandlerContext ctx, PreparationEvent evt) {
        super.prepareRequested(ctx, evt);
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        pipelineFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isCancelled()) {
                    handlerFuture.cancel();
                } else if (!f.isSuccess()) {
                    handlerFuture.setFailure(f.getCause());
                } else {
                    Barrier barrier = AwaitBarrierUpstreamHandler.this.getBarrier();
                    ChannelFuture barrierFuture = barrier.getFuture();
                    barrierFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
                }
            }
        });
        this.queue = new ConcurrentLinkedQueue<ChannelEvent>();
        handlerFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelHandlerContext channelHandlerContext = ctx;
                synchronized (channelHandlerContext) {
                    if (future.isSuccess()) {
                        Queue pending = AwaitBarrierUpstreamHandler.this.queue;
                        AwaitBarrierUpstreamHandler.this.queue = null;
                        for (ChannelEvent evt : pending) {
                            ctx.sendUpstream(evt);
                        }
                    }
                }
            }
        });
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("read await %s", this.getBarrier()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            if (!handlerFuture.isDone()) {
                this.queue.add(evt);
                return;
            }
            ctx.sendUpstream(evt);
        }
    }

    boolean hasQueuedChannelEvents() {
        return this.queue != null && !this.queue.isEmpty();
    }
}

