/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;

public class WriteExpressionEncoder
implements MessageEncoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(WriteExpressionEncoder.class);
    private final Supplier<Object> supplier;
    private final ValueExpression expression;

    public WriteExpressionEncoder(Supplier<Object> supplier, ValueExpression expression) {
        this.supplier = supplier;
        this.expression = expression;
    }

    @Override
    public ChannelBuffer encode(ChannelBufferFactory bufferFactory) {
        ChannelBuffer result;
        Object value = this.supplier.get();
        if (value != null) {
            result = this.asChannelBuffer(bufferFactory, value);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Value of expression is null. Encoding as a 0 length buffer");
            }
            result = ChannelBuffers.buffer((ByteOrder)bufferFactory.getDefaultOrder(), (int)0);
        }
        return result;
    }

    public String toString() {
        return this.expression.getExpressionString();
    }

    private ChannelBuffer asChannelBuffer(ChannelBufferFactory bufferFactory, Object value) {
        ChannelBuffer result;
        if (value instanceof byte[]) {
            byte[] valueBytes = (byte[])value;
            result = bufferFactory.getBuffer(valueBytes, 0, valueBytes.length);
        } else if (value instanceof Long) {
            result = bufferFactory.getBuffer(8);
            result.setLong(0, ((Long)value).longValue());
            result.writerIndex(8);
        } else if (value instanceof Integer) {
            result = bufferFactory.getBuffer(4);
            result.setInt(0, ((Integer)value).intValue());
            result.writerIndex(4);
        } else if (value instanceof Short) {
            result = bufferFactory.getBuffer(2);
            result.setShort(0, (int)((Short)value).shortValue());
            result.writerIndex(2);
        } else if (value instanceof Byte) {
            result = bufferFactory.getBuffer(1);
            result.setByte(0, (int)((Byte)value).byteValue());
            result.writerIndex(1);
        } else if (value instanceof String) {
            byte[] valueBytes = ((String)value).getBytes(StandardCharsets.UTF_8);
            result = bufferFactory.getBuffer(valueBytes, 0, valueBytes.length);
        } else {
            throw new ELException(String.format("Unable to encode expression value \"%s\" of type \"$s\" of expression \"%s\"", value.toString(), value.getClass(), this.expression.toString()));
        }
        return result;
    }
}

