/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.StandardCharsets;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpMethodEncoder
implements ConfigEncoder {
    private final MessageEncoder methodEncoder;

    public HttpMethodEncoder(MessageEncoder methodEncoder) {
        this.methodEncoder = methodEncoder;
    }

    @Override
    public void encode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        ChannelBufferFactory bufferFactory = httpConfig.getBufferFactory();
        String methodName = this.methodEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
        HttpMethod method = HttpMethod.valueOf((String)methodName);
        httpConfig.setMethod(method);
    }

    public String toString() {
        return String.format("http:method %s", this.methodEncoder);
    }
}

