/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.StandardCharsets;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpStatusEncoder
implements ConfigEncoder {
    private final MessageEncoder codeEncoder;
    private final MessageEncoder reasonEncoder;

    public HttpStatusEncoder(MessageEncoder codeEncoder, MessageEncoder reasonEncoder) {
        this.codeEncoder = codeEncoder;
        this.reasonEncoder = reasonEncoder;
    }

    @Override
    public void encode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        ChannelBufferFactory bufferFactory = httpConfig.getBufferFactory();
        int code = Integer.parseInt(this.codeEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII));
        String reason = this.reasonEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
        HttpResponseStatus status = new HttpResponseStatus(code, reason);
        httpConfig.setStatus(status);
    }

    public String toString() {
        return String.format("http:status %s %s", this.codeEncoder, this.reasonEncoder);
    }
}

