/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.Masker;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;

public class WriteHandler
extends AbstractCommandHandler {
    private final List<MessageEncoder> encoders;
    private final Masker masker;

    public WriteHandler(List<MessageEncoder> encoders, Masker masker) {
        if (encoders == null) {
            throw new NullPointerException("encoders");
        }
        if (encoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one encoder");
        }
        this.encoders = encoders;
        this.masker = masker;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        ChannelBuffer bytes;
        ChannelConfig config = ctx.getChannel().getConfig();
        ChannelBufferFactory bufferFactory = config.getBufferFactory();
        ChannelBuffer[] buffers = new ChannelBuffer[this.encoders.size()];
        int idx = 0;
        for (MessageEncoder encoder : this.encoders) {
            buffers[idx] = encoder.encode(bufferFactory);
            ++idx;
        }
        if (this.masker == Masker.IDENTITY_MASKER) {
            bytes = ChannelBuffers.wrappedBuffer((ChannelBuffer[])buffers);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)this.getHandlerFuture(), (Object)bytes);
        } else {
            bytes = ChannelBuffers.copiedBuffer((ChannelBuffer[])buffers);
            ChannelBuffer maskedBytes = this.masker.applyMask(bytes);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)this.getHandlerFuture(), (Object)maskedBytes);
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        sb.append("write ");
        for (MessageEncoder encoder : this.encoders) {
            sb.append(encoder).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }
}

