/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command.file;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.file.FileChannel;

public class WriteOptionFileOffsetHandler
extends AbstractCommandHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(WriteOptionFileOffsetHandler.class);
    private final int offset;

    public WriteOptionFileOffsetHandler(int offset) {
        this.offset = offset;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        FileChannel channel = (FileChannel)ctx.getChannel();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Setting write option offset %d for channel %s", new Object[]{this.offset, channel}));
        }
        try {
            channel.setWriteOffset(this.offset);
            this.getHandlerFuture().setSuccess();
        }
        catch (Throwable t) {
            this.getHandlerFuture().setFailure(t);
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append("write option offset " + this.offset);
    }
}

