/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstAcceptNode;
import org.kaazing.k3po.lang.internal.ast.AstAcceptableNode;
import org.kaazing.k3po.lang.internal.ast.AstAcceptedNode;
import org.kaazing.k3po.lang.internal.ast.AstBoundNode;
import org.kaazing.k3po.lang.internal.ast.AstChildClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstChildOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstReadClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstReadNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstReadValueNode;
import org.kaazing.k3po.lang.internal.ast.AstRegionException;
import org.kaazing.k3po.lang.internal.ast.AstRejectedNode;
import org.kaazing.k3po.lang.internal.ast.AstScriptNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamableNode;
import org.kaazing.k3po.lang.internal.ast.AstUnbindNode;
import org.kaazing.k3po.lang.internal.ast.AstUnboundNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteFlushNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteValueNode;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;

public class AssociateStreamsVisitor
implements AstNode.Visitor<AstScriptNode, State> {
    public AstScriptNode visit(AstScriptNode script, State state) {
        AstScriptNode newScript = new AstScriptNode();
        newScript.setRegionInfo(script.getRegionInfo());
        newScript.getProperties().addAll(script.getProperties());
        state.streams = newScript.getStreams();
        for (AstStreamNode stream : script.getStreams()) {
            stream.accept((AstNode.Visitor)this, (Object)state);
        }
        for (AstAcceptNode accept : state.accepts.values()) {
            newScript.getStreams().removeAll(accept.getAcceptables());
        }
        return newScript;
    }

    public AstScriptNode visit(AstPropertyNode propertyNode, State state) {
        return null;
    }

    public AstScriptNode visit(AstAcceptNode acceptNode, State state) {
        AstAcceptNode newAcceptNode = new AstAcceptNode(acceptNode);
        String acceptName = acceptNode.getAcceptName();
        String newAcceptName = acceptName != null ? acceptName : String.format("~accept~%d", ++state.implicitAcceptCount);
        state.accepts.put(newAcceptName, newAcceptNode);
        state.implicitAcceptName = newAcceptName;
        state.streamables = newAcceptNode.getStreamables();
        for (AstStreamableNode streamable : acceptNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        for (AstAcceptableNode acceptable : acceptNode.getAcceptables()) {
            assert (AstUtil.equivalent((Object)acceptName, (Object)acceptable.getAcceptName()));
            acceptable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newAcceptNode);
        return null;
    }

    public AstScriptNode visit(AstAcceptedNode acceptedNode, State state) {
        AstAcceptNode acceptNode;
        AstAcceptedNode newAcceptedNode = new AstAcceptedNode();
        newAcceptedNode.setRegionInfo(acceptedNode.getRegionInfo());
        String acceptName = acceptedNode.getAcceptName();
        if (acceptName == null) {
            acceptName = state.implicitAcceptName;
        }
        if ((acceptNode = (AstAcceptNode)state.accepts.get(acceptName)) == null) {
            RegionInfo regionInfo = acceptedNode.getRegionInfo();
            throw new AstRegionException("Accept not found for accepted").initRegionInfo(regionInfo);
        }
        state.streamables = newAcceptedNode.getStreamables();
        for (AstStreamableNode streamable : acceptedNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        acceptNode.getAcceptables().add(newAcceptedNode);
        return null;
    }

    public AstScriptNode visit(AstRejectedNode rejectedNode, State state) {
        AstAcceptNode acceptNode;
        AstRejectedNode newRejectedNode = new AstRejectedNode();
        newRejectedNode.setRegionInfo(rejectedNode.getRegionInfo());
        String acceptName = rejectedNode.getAcceptName();
        if (acceptName == null) {
            acceptName = state.implicitAcceptName;
        }
        if ((acceptNode = (AstAcceptNode)state.accepts.get(acceptName)) == null) {
            RegionInfo regionInfo = rejectedNode.getRegionInfo();
            throw new AstRegionException("Accept not found for accepted").initRegionInfo(regionInfo);
        }
        state.streamables = newRejectedNode.getStreamables();
        for (AstStreamableNode streamable : rejectedNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        acceptNode.getAcceptables().add(newRejectedNode);
        return null;
    }

    public AstScriptNode visit(AstConnectNode connectNode, State state) {
        AstConnectNode newConnectNode = new AstConnectNode(connectNode);
        state.streamables = newConnectNode.getStreamables();
        for (AstStreamableNode streamable : connectNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newConnectNode);
        return null;
    }

    public AstScriptNode visit(AstConnectAbortNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstConnectAbortedNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadAwaitNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAwaitNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadNotifyNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteNotifyNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteValueNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstDisconnectNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstUnbindNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstCloseNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAbortNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadAbortNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstChildOpenedNode childOpenedNode, State state) {
        state.streamables.add(childOpenedNode);
        return null;
    }

    public AstScriptNode visit(AstChildClosedNode childClosedNode, State state) {
        state.streamables.add(childClosedNode);
        return null;
    }

    public AstScriptNode visit(AstReadAbortedNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAbortedNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstOpenedNode openedNode, State state) {
        state.streamables.add(openedNode);
        return null;
    }

    public AstScriptNode visit(AstBoundNode boundNode, State state) {
        state.streamables.add(boundNode);
        return null;
    }

    public AstScriptNode visit(AstConnectedNode connectedNode, State state) {
        state.streamables.add(connectedNode);
        return null;
    }

    public AstScriptNode visit(AstReadValueNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstDisconnectedNode disconnectedNode, State state) {
        state.streamables.add(disconnectedNode);
        return null;
    }

    public AstScriptNode visit(AstUnboundNode unboundNode, State state) {
        state.streamables.add(unboundNode);
        return null;
    }

    public AstScriptNode visit(AstClosedNode closedNode, State state) {
        state.streamables.add(closedNode);
        return null;
    }

    public AstScriptNode visit(AstReadConfigNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteConfigNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadClosedNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteCloseNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteFlushNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadOptionNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteOptionNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public static final class State {
        private List<AstStreamNode> streams;
        private List<AstStreamableNode> streamables;
        private Map<String, AstAcceptNode> accepts = new HashMap<String, AstAcceptNode>();
        private String implicitAcceptName;
        private int implicitAcceptCount;
    }

    public static enum ReadWriteState {
        NONE,
        READ,
        WRITE;

    }
}

