/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.Robot;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.control.AwaitMessage;
import org.kaazing.k3po.driver.internal.control.ErrorMessage;
import org.kaazing.k3po.driver.internal.control.FinishedMessage;
import org.kaazing.k3po.driver.internal.control.NotifiedMessage;
import org.kaazing.k3po.driver.internal.control.NotifyMessage;
import org.kaazing.k3po.driver.internal.control.PrepareMessage;
import org.kaazing.k3po.driver.internal.control.PreparedMessage;
import org.kaazing.k3po.driver.internal.control.StartedMessage;
import org.kaazing.k3po.driver.internal.control.handler.ControlUpstreamHandler;
import org.kaazing.k3po.driver.internal.control.handler.OriginScript;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;
import org.kaazing.k3po.lang.internal.parser.ScriptParseStrategy;
import org.kaazing.k3po.lang.internal.parser.ScriptParserImpl;

public class ControlServerHandler
extends ControlUpstreamHandler {
    private static final Map<String, Object> EMPTY_ENVIRONMENT = Collections.emptyMap();
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ControlServerHandler.class);
    private static final String ERROR_MSG_NOT_PREPARED = "Script has not been prepared or is still preparing\n";
    private static final String ERROR_MSG_ALREADY_PREPARED = "Script already prepared\n";
    private static final String ERROR_MSG_ALREADY_STARTED = "Script has already been started\n";
    private AtomicReference<Robot> activeRobotRef;
    private Robot robot;
    private ChannelFutureListener whenAbortedOrFinished;
    private volatile boolean isFinishedSent = false;
    private final ChannelFuture channelClosedFuture = Channels.future(null);
    private ClassLoader scriptLoader;

    public ControlServerHandler(AtomicReference<Robot> activeRobotRef) {
        this.activeRobotRef = activeRobotRef;
    }

    public void setScriptLoader(ClassLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    public ChannelFuture getChannelClosedFuture() {
        return this.channelClosedFuture;
    }

    public void channelClosed(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        if (this.robot != null) {
            this.robot.dispose().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ControlServerHandler.this.channelClosedFuture.setSuccess();
                    ctx.sendUpstream((ChannelEvent)e);
                    ControlServerHandler.this.activeRobotRef.compareAndSet(ControlServerHandler.this.robot, null);
                }
            });
        }
    }

    @Override
    public void closeReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.robot != null) {
            this.robot.dispose().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ctx.getChannel().close();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareReceived(final ChannelHandlerContext ctx, final MessageEvent evt) throws Exception {
        ChannelFuture prepareFuture;
        if (this.robot != null && this.robot.getPreparedFuture() != null) {
            this.sendErrorMessage(ctx, ERROR_MSG_ALREADY_PREPARED);
            return;
        }
        if (this.robot == null) {
            this.robot = new Robot();
        }
        if (this.activeRobotRef.get() != this.robot && !this.activeRobotRef.compareAndSet(null, this.robot)) {
            Robot activeRobot = this.activeRobotRef.get();
            if (activeRobot == null) {
                this.prepareReceived(ctx, evt);
            } else {
                activeRobot.getDisposedFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ((NioSocketChannel)ctx.getChannel()).getWorker().executeInIoThread(() -> {
                            try {
                                ControlServerHandler.this.prepareReceived(ctx, evt);
                            }
                            catch (Exception e) {
                                ControlServerHandler.this.sendErrorMessage(ctx, e);
                            }
                        }, true);
                    }
                });
                return;
            }
        }
        if (ctx.getChannel().getCloseFuture().isDone()) {
            return;
        }
        PrepareMessage prepare = (PrepareMessage)evt.getMessage();
        String version = prepare.getVersion();
        if (!"2.0".equals(version)) {
            this.sendVersionError(ctx);
            return;
        }
        List<String> scriptNames = prepare.getNames();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("preparing script(s) " + scriptNames);
        }
        this.whenAbortedOrFinished = this.whenAbortedOrFinished(ctx);
        String originScript = "";
        String origin = prepare.getOrigin();
        if (origin != null) {
            try {
                originScript = OriginScript.get(origin);
            }
            catch (URISyntaxException e) {
                throw new Exception("Could not find origin: ", e);
            }
        }
        String aggregatedScript = originScript + ControlServerHandler.aggregateScript(scriptNames, this.scriptLoader);
        List<String> properyOverrides = prepare.getProperties();
        aggregatedScript = this.injectOverridenProperties(aggregatedScript, properyOverrides);
        if (this.scriptLoader != null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.scriptLoader);
                prepareFuture = this.robot.prepare(aggregatedScript);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        } else {
            prepareFuture = this.robot.prepare(aggregatedScript);
        }
        final String scriptToRun = aggregatedScript;
        prepareFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                PreparedMessage prepared = new PreparedMessage();
                prepared.setScript(scriptToRun);
                prepared.getBarriers().addAll(ControlServerHandler.this.robot.getBarriersByName().keySet());
                ControlServerHandler.this.writeEvent(ctx, prepared);
            }
        });
    }

    private String injectOverridenProperties(String aggregatedScript, List<String> scriptProperties) throws Exception, ScriptParseException {
        ScriptParserImpl parser = new ScriptParserImpl();
        for (String propertyToInject : scriptProperties) {
            String propertyName = ((AstPropertyNode)parser.parseWithStrategy(propertyToInject, ScriptParseStrategy.PROPERTY_NODE)).getPropertyName();
            StringBuilder replacementScript = new StringBuilder();
            Pattern pattern = Pattern.compile("property\\s+" + propertyName + "\\s+.+");
            boolean matchFound = false;
            for (String scriptLine : aggregatedScript.split("\\r?\\n")) {
                if (pattern.matcher(scriptLine).matches()) {
                    matchFound = true;
                    replacementScript.append(propertyToInject + "\n");
                    continue;
                }
                replacementScript.append(scriptLine + "\n");
            }
            if (!matchFound) {
                String errorMsg = "Received " + propertyToInject + " in PREPARE but found no where to substitute it";
                LOGGER.error(errorMsg);
                throw new Exception(errorMsg);
            }
            aggregatedScript = replacementScript.toString();
        }
        return aggregatedScript;
    }

    public static String aggregateScript(List<String> scriptNames, ClassLoader scriptLoader) throws URISyntaxException, IOException {
        StringBuilder aggregatedScript = new StringBuilder();
        for (String scriptName : scriptNames) {
            URL resource;
            String scriptNameWithExtension = String.format("%s.rpt", scriptName);
            Path scriptPath = Paths.get(scriptNameWithExtension, new String[0]);
            scriptNameWithExtension = URI.create(scriptNameWithExtension).normalize().getPath();
            String script = null;
            assert (!scriptPath.isAbsolute());
            if (scriptLoader != null && (resource = scriptLoader.getResource(scriptNameWithExtension)) != null) {
                URI resourceURI = resource.toURI();
                if ("file".equals(resourceURI.getScheme())) {
                    Path resourcePath = Paths.get(resourceURI);
                    script = ControlServerHandler.readScript(resourcePath);
                } else {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(resourceURI, EMPTY_ENVIRONMENT);){
                        Path resourcePath = Paths.get(resourceURI);
                        script = ControlServerHandler.readScript(resourcePath);
                    }
                }
            }
            if (script == null) {
                throw new RuntimeException("Script not found: " + scriptPath);
            }
            aggregatedScript.append(script);
        }
        return aggregatedScript.toString();
    }

    private static String readScript(Path scriptPath) throws IOException {
        List<String> lines = Files.readAllLines(scriptPath, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append("\n");
        }
        String script = sb.toString();
        return script;
    }

    @Override
    public void startReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        if (this.robot == null || this.robot.getPreparedFuture() == null) {
            this.sendErrorMessage(ctx, ERROR_MSG_NOT_PREPARED);
            return;
        }
        if (this.robot.getStartedFuture().isDone()) {
            this.sendErrorMessage(ctx, ERROR_MSG_ALREADY_STARTED);
            return;
        }
        ChannelFuture startFuture = this.robot.start();
        startFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                if (f.isSuccess()) {
                    StartedMessage started = new StartedMessage();
                    ControlServerHandler.this.writeEvent(ctx, started);
                } else {
                    ControlServerHandler.this.sendErrorMessage(ctx, f.getCause());
                }
            }
        });
        assert (this.whenAbortedOrFinished != null);
        this.robot.finish().addListener(this.whenAbortedOrFinished);
    }

    @Override
    public void abortReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ABORT");
        }
        if (this.robot == null || this.robot.getPreparedFuture() == null) {
            this.sendErrorMessage(ctx, ERROR_MSG_NOT_PREPARED);
            return;
        }
        assert (this.whenAbortedOrFinished != null);
        this.robot.abort().addListener(this.whenAbortedOrFinished);
    }

    @Override
    public void notifyReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        NotifyMessage notifyMessage = (NotifyMessage)evt.getMessage();
        String barrier = notifyMessage.getBarrier();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("NOTIFY: " + barrier);
        }
        if (this.robot == null || this.robot.getPreparedFuture() == null) {
            this.sendErrorMessage(ctx, ERROR_MSG_NOT_PREPARED);
            return;
        }
        this.writeNotifiedOnBarrier(barrier, ctx);
        this.robot.notifyBarrier(barrier);
    }

    @Override
    public void awaitReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        AwaitMessage awaitMessage = (AwaitMessage)evt.getMessage();
        String barrier = awaitMessage.getBarrier();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AWAIT: " + barrier);
        }
        if (this.robot == null || this.robot.getPreparedFuture() == null) {
            this.sendErrorMessage(ctx, ERROR_MSG_NOT_PREPARED);
            return;
        }
        this.writeNotifiedOnBarrier(barrier, ctx);
    }

    private void writeNotifiedOnBarrier(final String barrier, final ChannelHandlerContext ctx) throws Exception {
        this.robot.awaitBarrier(barrier).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    LOGGER.debug("sending NOTIFIED: " + barrier);
                    NotifiedMessage notified = new NotifiedMessage();
                    notified.setBarrier(barrier);
                    ControlServerHandler.this.writeEvent(ctx, notified);
                }
            }
        });
    }

    private ChannelFutureListener whenAbortedOrFinished(final ChannelHandlerContext ctx) {
        final AtomicBoolean oneTimeOnly = new AtomicBoolean();
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (oneTimeOnly.compareAndSet(false, true)) {
                    ControlServerHandler.this.sendFinishedMessage(ctx);
                }
            }
        };
    }

    private void sendFinishedMessage(ChannelHandlerContext ctx) {
        String observedScript = this.robot.getObservedScript();
        FinishedMessage finishedMessage = new FinishedMessage();
        finishedMessage.setScript(observedScript);
        Map<String, Barrier> barriers = this.robot.getBarriersByName();
        for (String name : barriers.keySet()) {
            if (barriers.get(name).getFuture().isSuccess()) {
                finishedMessage.getCompletedBarriers().add(name);
                continue;
            }
            finishedMessage.getIncompleteBarriers().add(name);
        }
        this.writeEvent(ctx, finishedMessage);
    }

    private void sendVersionError(ChannelHandlerContext ctx) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setSummary("Bad control protocol version");
        errorMessage.setDescription("Robot requires control protocol version 2.0");
        this.writeEvent(ctx, errorMessage);
    }

    private void writeEvent(ChannelHandlerContext ctx, Object message) {
        if (this.isFinishedSent) {
            return;
        }
        if (message instanceof FinishedMessage) {
            this.isFinishedSent = true;
        }
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)message);
    }
}

