/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.ext.tls.bootstrap;

import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.ssl.SslHandler;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAbortEvent;

public class TlsChildChannelSink
extends AbstractChannelSink {
    private final Channel transport;

    public TlsChildChannelSink(Channel transport) {
        this.transport = Objects.requireNonNull(transport);
    }

    public ChannelFuture execute(ChannelPipeline httpPipeline, Runnable task) {
        ChannelPipeline pipeline = this.transport.getPipeline();
        ChannelFuture future = pipeline.execute(task);
        Channel tlsChannel = pipeline.getChannel();
        ChannelFuture tlsFuture = org.jboss.netty.channel.Channels.future((Channel)tlsChannel);
        org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(future, tlsFuture);
        return tlsFuture;
    }

    @Override
    protected void setInterestOpsRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
    }

    @Override
    protected void writeRequested(ChannelPipeline httpPipeline, MessageEvent e) throws Exception {
        ChannelFuture tlsFuture = e.getFuture();
        ChannelBuffer tlsContent = (ChannelBuffer)e.getMessage();
        int tlsReadableBytes = tlsContent.readableBytes();
        ChannelFuture future = this.transport.write((Object)tlsContent);
        org.kaazing.k3po.driver.internal.channel.Channels.chainWriteCompletes(future, tlsFuture, tlsReadableBytes);
    }

    @Override
    protected void flushRequested(ChannelPipeline pipeline, FlushEvent evt) throws Exception {
        TlsChildChannel tlsChildChannel = (TlsChildChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        this.flushRequested(tlsChildChannel, tlsFuture);
    }

    @Override
    protected void abortInputRequested(ChannelPipeline pipeline, ReadAbortEvent evt) throws Exception {
        ChannelHandlerContext ctx = this.transport.getPipeline().getContext(SslHandler.class);
        ChannelFuture tlsFuture = evt.getFuture();
        Channels.abortInputOrSuccess(ctx, tlsFuture);
    }

    @Override
    protected void abortOutputRequested(ChannelPipeline pipeline, WriteAbortEvent evt) throws Exception {
        ChannelHandlerContext ctx = this.transport.getPipeline().getContext(SslHandler.class);
        ChannelFuture tlsFuture = evt.getFuture();
        Channels.abortOutputOrClose(ctx, tlsFuture);
    }

    @Override
    protected void shutdownOutputRequested(ChannelPipeline pipeline, ShutdownOutputEvent evt) throws Exception {
        TlsChildChannel tlsChildChannel = (TlsChildChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        this.shutdownOutputRequested(tlsChildChannel, tlsFuture);
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        TlsChildChannel tlsChildChannel = (TlsChildChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        this.closeRequested(tlsChildChannel, tlsFuture);
    }

    private void shutdownOutputRequested(final TlsChildChannel tlsChildChannel, ChannelFuture tlsFuture) {
        SslHandler tlsHandler = (SslHandler)this.transport.getPipeline().get(SslHandler.class);
        if (tlsChildChannel.isReadClosed()) {
            org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(Channels.shutdownOutputOrClose(this.transport), tlsFuture);
        } else if (tlsHandler != null) {
            ChannelFuture tlsCloseFuture = tlsHandler.close();
            tlsCloseFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (tlsChildChannel.setWriteClosed()) {
                        Channels.fireOutputShutdown((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
                    } else {
                        Channels.fireOutputShutdown((Channel)tlsChildChannel);
                    }
                }
            });
            tlsHandler.getSSLEngineInboundCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channels.shutdownOutputOrClose(TlsChildChannelSink.this.transport);
                }
            });
            org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(tlsCloseFuture, tlsFuture);
        }
    }

    private void closeRequested(TlsChildChannel tlsChildChannel, ChannelFuture tlsFuture) {
        if (!tlsChildChannel.isOpen()) {
            tlsFuture.setSuccess();
        } else {
            tlsChildChannel.setReadClosed();
            this.shutdownOutputRequested(tlsChildChannel, tlsFuture);
        }
    }

    private void flushRequested(TlsChildChannel tlsChildChannel, ChannelFuture tlsFuture) {
        tlsFuture.setSuccess();
    }
}

