/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.ext.tls.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.ssl.SslHandler;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChannelConfig;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsClientChannel;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsClientChannelSource;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAbortEvent;

public class TlsClientChannelSink
extends AbstractChannelSink {
    private final SecureRandom random;
    private final BootstrapFactory bootstrapFactory;
    private Channel transport;

    public TlsClientChannelSink(SecureRandom random, BootstrapFactory bootstrapFactory) {
        this.random = random;
        this.bootstrapFactory = bootstrapFactory;
    }

    public ChannelFuture execute(ChannelPipeline tlsPipeline, Runnable task) {
        if (this.transport != null) {
            ChannelPipeline pipeline = this.transport.getPipeline();
            ChannelFuture future = pipeline.execute(task);
            Channel tlsChannel = pipeline.getChannel();
            ChannelFuture tlsFuture = org.jboss.netty.channel.Channels.future((Channel)tlsChannel);
            org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(future, tlsFuture);
            return tlsFuture;
        }
        return super.execute(tlsPipeline, task);
    }

    @Override
    protected void setInterestOpsRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelFuture tlsFuture = evt.getFuture();
        TlsClientChannel tlsClientChannel = (TlsClientChannel)evt.getChannel();
        tlsClientChannel.setInterestOpsNow((Integer)evt.getValue());
        tlsFuture.setSuccess();
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelFuture tlsBindFuture = evt.getFuture();
        TlsClientChannel tlsConnectChannel = (TlsClientChannel)evt.getChannel();
        ChannelAddress tlsLocalAddress = (ChannelAddress)evt.getValue();
        tlsConnectChannel.setLocalAddress(tlsLocalAddress);
        tlsConnectChannel.setBound();
        org.jboss.netty.channel.Channels.fireChannelBound((Channel)tlsConnectChannel, (SocketAddress)tlsLocalAddress);
        tlsBindFuture.setSuccess();
    }

    @Override
    protected void connectRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final TlsClientChannel tlsClientChannel = (TlsClientChannel)evt.getChannel();
        final ChannelFuture tlsConnectFuture = evt.getFuture();
        final ChannelAddress tlsRemoteAddress = (ChannelAddress)evt.getValue();
        final URI tlsLocation = tlsRemoteAddress.getLocation();
        ChannelAddress address = tlsRemoteAddress.getTransport();
        String schemeName = address.getLocation().getScheme();
        String tlsSchemeName = tlsLocation.getScheme();
        final TlsChannelConfig tlsConnectConfig = (TlsChannelConfig)tlsClientChannel.getConfig();
        final File keyStoreFile = tlsConnectConfig.getKeyStoreFile();
        final File trustStoreFile = tlsConnectConfig.getTrustStoreFile();
        final char[] keyStorePassword = tlsConnectConfig.getKeyStorePassword();
        final char[] trustStorePassword = tlsConnectConfig.getTrustStorePassword();
        final String[] applicationProtocols = tlsConnectConfig.getApplicationProtocols();
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                KeyManager[] keyManagers = null;
                if (keyStoreFile != null) {
                    KeyStore keys = KeyStore.getInstance("JKS");
                    keys.load(new FileInputStream(keyStoreFile), keyStorePassword);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
                    kmf.init(keys, keyStorePassword);
                    keyManagers = kmf.getKeyManagers();
                }
                TrustManager[] trustManagers = null;
                if (trustStoreFile != null) {
                    KeyStore trusts = KeyStore.getInstance("JKS");
                    trusts.load(new FileInputStream(trustStoreFile), trustStorePassword);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trusts);
                    trustManagers = tmf.getTrustManagers();
                }
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(keyManagers, trustManagers, TlsClientChannelSink.this.random);
                String tlsHostname = tlsLocation.getHost();
                int tlsPort = tlsLocation.getPort();
                SSLEngine tlsEngine = tlsContext.createSSLEngine(tlsHostname, tlsPort);
                tlsEngine.setUseClientMode(true);
                SSLParameters tlsParameters = tlsEngine.getSSLParameters();
                tlsParameters.setEndpointIdentificationAlgorithm("HTTPS");
                tlsParameters.setServerNames(Arrays.asList(new SNIHostName(tlsHostname)));
                if (applicationProtocols != null && applicationProtocols.length > 0) {
                    TlsClientChannelSink.setApplicationProtocols(tlsParameters, applicationProtocols);
                }
                tlsEngine.setSSLParameters(tlsParameters);
                SslHandler sslHandler = new SslHandler(tlsEngine);
                sslHandler.setIssueHandshake(true);
                return org.jboss.netty.channel.Channels.pipeline((ChannelHandler[])new ChannelHandler[]{sslHandler, new TlsClientChannelSource()});
            }
        };
        ClientBootstrap bootstrap = this.bootstrapFactory.newClientBootstrap(schemeName);
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOptions(((TlsChannelConfig)tlsClientChannel.getConfig()).getTransportOptions());
        bootstrap.setOption(String.format("%s.nextProtocol", schemeName), tlsSchemeName);
        ChannelFuture connectFuture = bootstrap.connect(address);
        connectFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture connectFuture) throws Exception {
                if (connectFuture.isSuccess()) {
                    TlsClientChannelSink.this.transport = connectFuture.getChannel();
                    TlsClientChannelSink.this.transport.getConfig().setBufferFactory(tlsConnectConfig.getBufferFactory());
                    final ChannelPipeline pipeline = TlsClientChannelSink.this.transport.getPipeline();
                    final SslHandler sslHandler = (SslHandler)pipeline.get(SslHandler.class);
                    ChannelFuture handshakeFuture = sslHandler.handshake();
                    handshakeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture handshakeFuture) throws Exception {
                            if (handshakeFuture.isSuccess()) {
                                TlsChannelConfig tlsConnectConfig = (TlsChannelConfig)tlsClientChannel.getConfig();
                                SSLEngine tlsEngine = sslHandler.getEngine();
                                tlsConnectConfig.setParameters(tlsEngine.getSSLParameters());
                                TlsClientChannelSource tlsChannelSource = (TlsClientChannelSource)pipeline.get(TlsClientChannelSource.class);
                                TlsClientChannelSink.this.detectWriteTransportClosed(TlsClientChannelSink.this.transport, tlsClientChannel);
                                ChannelFuture tlsCloseFuture = sslHandler.getSSLEngineInboundCloseFuture();
                                tlsCloseFuture.addListener(new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        if (tlsClientChannel != null) {
                                            if (tlsClientChannel.setReadClosed()) {
                                                Channels.fireInputShutdown((Channel)tlsClientChannel);
                                                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                                                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                                                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
                                            } else {
                                                Channels.fireInputShutdown((Channel)tlsClientChannel);
                                            }
                                        }
                                    }
                                });
                                if (!tlsClientChannel.isBound()) {
                                    ChannelAddress tlsLocalAddress = tlsRemoteAddress;
                                    tlsClientChannel.setLocalAddress(tlsLocalAddress);
                                    tlsClientChannel.setBound();
                                    org.jboss.netty.channel.Channels.fireChannelBound((Channel)tlsClientChannel, (SocketAddress)tlsLocalAddress);
                                }
                                tlsChannelSource.setTlsChannel(tlsClientChannel);
                                tlsClientChannel.setRemoteAddress(tlsRemoteAddress);
                                tlsClientChannel.setConnected();
                                tlsConnectFuture.setSuccess();
                                org.jboss.netty.channel.Channels.fireChannelConnected((Channel)tlsClientChannel, (SocketAddress)tlsRemoteAddress);
                            } else {
                                tlsConnectFuture.setFailure(handshakeFuture.getCause());
                            }
                        }
                    });
                } else {
                    tlsConnectFuture.setFailure(connectFuture.getCause());
                }
            }
        });
    }

    @Override
    protected void writeRequested(ChannelPipeline pipeline, MessageEvent e) throws Exception {
        ChannelFuture tlsFuture = e.getFuture();
        ChannelBuffer tlsContent = (ChannelBuffer)e.getMessage();
        int tlsReadableBytes = tlsContent.readableBytes();
        ChannelFuture future = this.transport.write((Object)tlsContent);
        org.kaazing.k3po.driver.internal.channel.Channels.chainWriteCompletes(future, tlsFuture, tlsReadableBytes);
    }

    @Override
    protected void flushRequested(ChannelPipeline pipeline, FlushEvent evt) throws Exception {
        TlsClientChannel tlsClientChannel = (TlsClientChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        this.flushRequested(tlsClientChannel, tlsFuture);
    }

    @Override
    protected void abortInputRequested(ChannelPipeline pipeline, ReadAbortEvent evt) throws Exception {
        ChannelHandlerContext ctx = this.transport.getPipeline().getContext(SslHandler.class);
        ChannelFuture tlsFuture = evt.getFuture();
        Channels.abortInputOrSuccess(ctx, tlsFuture);
    }

    @Override
    protected void abortOutputRequested(ChannelPipeline pipeline, WriteAbortEvent evt) throws Exception {
        ChannelHandlerContext ctx = this.transport.getPipeline().getContext(SslHandler.class);
        ChannelFuture tlsFuture = evt.getFuture();
        Channels.abortOutputOrClose(ctx, tlsFuture);
    }

    @Override
    protected void shutdownOutputRequested(ChannelPipeline pipeline, ShutdownOutputEvent evt) throws Exception {
        TlsClientChannel tlsClientChannel = (TlsClientChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        this.shutdownOutputRequested(tlsClientChannel, tlsFuture);
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        TlsClientChannel tlsClientChannel = (TlsClientChannel)pipeline.getChannel();
        ChannelFuture tlsFuture = evt.getFuture();
        if (!tlsClientChannel.isOpen()) {
            tlsFuture.setSuccess();
        } else {
            tlsClientChannel.setReadClosed();
            this.shutdownOutputRequested(tlsClientChannel, tlsFuture);
        }
    }

    private void shutdownOutputRequested(final TlsClientChannel tlsClientChannel, ChannelFuture tlsFuture) {
        SslHandler tlsHandler = (SslHandler)this.transport.getPipeline().get(SslHandler.class);
        if (tlsClientChannel.isReadClosed()) {
            org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(Channels.shutdownOutputOrClose(this.transport), tlsFuture);
        } else if (tlsHandler != null) {
            ChannelFuture tlsCloseFuture = tlsHandler.close();
            tlsCloseFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (tlsClientChannel.setWriteClosed()) {
                        Channels.fireOutputShutdown((Channel)tlsClientChannel);
                        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
                    } else {
                        Channels.fireOutputShutdown((Channel)tlsClientChannel);
                    }
                }
            });
            tlsHandler.getSSLEngineInboundCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channels.shutdownOutputOrClose(TlsClientChannelSink.this.transport);
                }
            });
            org.kaazing.k3po.driver.internal.channel.Channels.chainFutures(tlsCloseFuture, tlsFuture);
        }
    }

    private void flushRequested(TlsClientChannel httpClientChannel, ChannelFuture tlsFuture) throws Exception {
        tlsFuture.setSuccess();
    }

    private void detectWriteTransportClosed(final Channel transport, final TlsClientChannel tlsClientChannel) {
        Objects.requireNonNull(tlsClientChannel);
        final ChannelFutureListener closeListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (tlsClientChannel.setWriteClosed()) {
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
                }
            }
        };
        transport.getCloseFuture().addListener(closeListener);
        tlsClientChannel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                transport.getCloseFuture().removeListener(closeListener);
            }
        });
    }

    static void setApplicationProtocols(SSLParameters parameters, String[] protocols) {
        try {
            Method setApplicationProtocolsMethod = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            setApplicationProtocolsMethod.invoke((Object)parameters, new Object[]{protocols});
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot call SSLParameters#setApplicationProtocols(). Use JDK 9 to run k3po");
        }
    }
}

