/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.kaazing.k3po.driver.internal.executor.ExecutorServiceFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapException;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactorySpi;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.Utils;

public final class BootstrapFactory
implements ExternalResourceReleasable {
    private final Map<String, BootstrapFactorySpi> bootstrapFactories;

    private BootstrapFactory(Map<String, BootstrapFactorySpi> bootstrapFactories) {
        this.bootstrapFactories = Collections.unmodifiableMap(bootstrapFactories);
    }

    public static BootstrapFactory newBootstrapFactory() {
        Map<Class<?>, Object> injectables = Collections.emptyMap();
        return BootstrapFactory.newBootstrapFactory(injectables);
    }

    public static BootstrapFactory newBootstrapFactory(Map<Class<?>, Object> injectables) {
        ServiceLoader<BootstrapFactorySpi> loader = BootstrapFactory.loadBootstrapFactorySpi();
        HashMap<String, BootstrapFactorySpi> bootstrapFactories = new HashMap<String, BootstrapFactorySpi>();
        for (BootstrapFactorySpi bootstrapFactorySpi : loader) {
            String transportName = bootstrapFactorySpi.getTransportName();
            BootstrapFactorySpi oldBootstrapFactorySpi = bootstrapFactories.put(transportName, bootstrapFactorySpi);
            if (oldBootstrapFactorySpi == null) continue;
            throw new BootstrapException(String.format("Duplicate transport bootstrap factory: %s", transportName));
        }
        ExecutorServiceFactory executorServiceFactory = ExecutorServiceFactory.newInstance();
        BootstrapFactory bootstrapFactory = new BootstrapFactory(bootstrapFactories);
        for (BootstrapFactorySpi bootstrapFactorySpi : bootstrapFactories.values()) {
            Utils.inject(bootstrapFactorySpi, BootstrapFactory.class, bootstrapFactory);
            Utils.inject(bootstrapFactorySpi, ExecutorServiceFactory.class, executorServiceFactory);
            Utils.injectAll(bootstrapFactorySpi, injectables);
        }
        return bootstrapFactory;
    }

    public void shutdown() {
        for (BootstrapFactorySpi bootstrapFactory : this.bootstrapFactories.values()) {
            bootstrapFactory.shutdown();
        }
    }

    public void releaseExternalResources() {
        for (BootstrapFactorySpi bootstrapFactory : this.bootstrapFactories.values()) {
            bootstrapFactory.releaseExternalResources();
        }
    }

    public ServerBootstrap newServerBootstrap(String transportName) throws Exception {
        BootstrapFactorySpi bootstrapFactory = this.findBootstrapFactory(transportName);
        return bootstrapFactory.newServerBootstrap();
    }

    public ClientBootstrap newClientBootstrap(String transportName) throws Exception {
        BootstrapFactorySpi bootstrapFactory = this.findBootstrapFactory(transportName);
        return bootstrapFactory.newClientBootstrap();
    }

    private static ServiceLoader<BootstrapFactorySpi> loadBootstrapFactorySpi() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? ServiceLoader.load(BootstrapFactorySpi.class, loader) : ServiceLoader.load(BootstrapFactorySpi.class);
    }

    private BootstrapFactorySpi findBootstrapFactory(String transportName) throws BootstrapException {
        if (transportName == null) {
            throw new NullPointerException("transportName");
        }
        BootstrapFactorySpi bootstrapFactory = this.bootstrapFactories.get(transportName);
        if (bootstrapFactory == null) {
            throw new BootstrapException(String.format("Unable to load transport: %s", transportName));
        }
        return bootstrapFactory;
    }
}

