/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh;

import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ServerChannel;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshHttpHeaders;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshPollingChildChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshPollingChildChannelSource;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshServerChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshStrategy;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.netty.channel.LocationFactories;
import org.kaazing.k3po.driver.internal.netty.channel.LocationFactory;

public class BBoshHandshakeChildChannelSource
extends SimpleChannelHandler {
    private static final LocationFactory CHANGE_SCHEME_ONLY = LocationFactories.changeSchemeOnly("bbosh");
    private final NavigableMap<URI, BBoshServerChannel> bboshBindings;
    private ChannelAddressFactory addressFactory;
    private BootstrapFactory bootstrapFactory;

    public BBoshHandshakeChildChannelSource(NavigableMap<URI, BBoshServerChannel> bboshBindings) {
        this.bboshBindings = bboshBindings;
    }

    public void setAddressFactory(ChannelAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    public void setBootstrapFactory(BootstrapFactory bootstrapFactory) {
        this.bootstrapFactory = bootstrapFactory;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        final HttpChildChannel httpChannel = (HttpChildChannel)ctx.getChannel();
        final HttpChannelConfig httpConfig = (HttpChannelConfig)httpChannel.getConfig();
        ChannelAddress httpHandshakeLocalAddress = httpChannel.getLocalAddress();
        URI httpHandshakeLocalURI = httpHandshakeLocalAddress.getLocation();
        ChannelAddress httpHandshakeRemoteAddress = httpChannel.getRemoteAddress();
        URI httpHandshakeRemoteURI = httpHandshakeRemoteAddress.getLocation();
        if (!httpHandshakeRemoteURI.equals(httpHandshakeLocalURI)) {
            httpConfig.setStatus(HttpResponseStatus.NOT_FOUND);
            httpChannel.close();
            return;
        }
        final URI handshakeLocalURI = CHANGE_SCHEME_ONLY.createURI(httpHandshakeLocalURI);
        Map.Entry<URI, BBoshServerChannel> binding = this.bboshBindings.floorEntry(handshakeLocalURI);
        if (binding == null) {
            httpConfig.setStatus(HttpResponseStatus.NOT_FOUND);
            httpChannel.close();
            return;
        }
        if (httpConfig.getMethod() != HttpMethod.POST) {
            httpConfig.setStatus(HttpResponseStatus.METHOD_NOT_ALLOWED);
            httpChannel.close();
            return;
        }
        HttpHeaders httpReadHeaders = httpConfig.getReadHeaders();
        if (!"bbosh/1.0".equals(httpReadHeaders.get("X-Protocol"))) {
            httpConfig.setStatus(HttpResponseStatus.BAD_REQUEST);
            httpChannel.close();
            return;
        }
        if (!"application/octet-stream".equals(httpReadHeaders.get("Accept"))) {
            httpConfig.setStatus(HttpResponseStatus.BAD_REQUEST);
            httpChannel.close();
            return;
        }
        List<BBoshStrategy> acceptStrategies = BBoshHandshakeChildChannelSource.readAcceptStrategies(httpReadHeaders);
        BBoshStrategy strategy = null;
        for (BBoshStrategy acceptStrategy : acceptStrategies) {
            switch (acceptStrategy.getKind()) {
                case POLLING: {
                    strategy = acceptStrategy;
                    break;
                }
            }
        }
        final BBoshStrategy negotiatedStrategy = strategy;
        if (strategy == null) {
            httpConfig.setStatus(HttpResponseStatus.BAD_REQUEST);
            httpChannel.close();
            return;
        }
        switch (strategy.getKind()) {
            case POLLING: {
                if (strategy.getInterval(TimeUnit.SECONDS) >= 5L) break;
                httpConfig.setStatus(HttpResponseStatus.BAD_REQUEST);
                httpChannel.close();
                return;
            }
            case LONG_POLLING: {
                if (strategy.getInterval(TimeUnit.SECONDS) >= 30L) break;
                httpConfig.setStatus(HttpResponseStatus.BAD_REQUEST);
                httpChannel.close();
                return;
            }
        }
        UUID uuid = UUID.randomUUID();
        String connectionId = uuid.toString();
        String httpHandshakeLocalPath = httpHandshakeLocalURI.getPath();
        if (!httpHandshakeLocalPath.endsWith("/")) {
            httpHandshakeLocalPath = httpHandshakeLocalPath + "/";
        }
        final String connectionPath = String.format("%s%s", httpHandshakeLocalPath, connectionId);
        int sequenceNo = BBoshHttpHeaders.getIntHeader(httpReadHeaders, "X-Sequence-No");
        int nextSequenceNo = sequenceNo + 1;
        BBoshServerChannel parent = binding.getValue();
        ChannelFactory factory = parent.getFactory();
        Object config = parent.getConfig();
        ChannelPipelineFactory pipelineFactory = config.getPipelineFactory();
        ChannelPipeline pipeline = pipelineFactory.getPipeline();
        BBoshPollingChildChannelSink sink = new BBoshPollingChildChannelSink(nextSequenceNo);
        final BBoshChildChannel channel = new BBoshChildChannel((ServerChannel)parent, factory, pipeline, (ChannelSink)sink);
        Channels.fireChannelOpen((Channel)channel);
        final URI httpConnectionLocalURI = httpHandshakeLocalURI.resolve(connectionPath);
        ChannelAddress httpConnectionLocalAddress = this.addressFactory.newChannelAddress(httpConnectionLocalURI);
        ServerBootstrap server = this.bootstrapFactory.newServerBootstrap("http");
        server.setPipeline(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new BBoshPollingChildChannelSource(channel)}));
        ChannelFuture httpBindFuture = server.bindAsync(httpConnectionLocalAddress);
        httpBindFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture httpBindFuture) throws Exception {
                if (httpBindFuture.isSuccess()) {
                    URI connectionLocalURI = handshakeLocalURI.resolve(connectionPath);
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("bbosh.transport", httpConnectionLocalURI);
                    ChannelAddress connectionLocalAddress = BBoshHandshakeChildChannelSource.this.addressFactory.newChannelAddress(connectionLocalURI, options);
                    channel.setLocalAddress(connectionLocalAddress);
                    channel.setBound();
                    Channels.fireChannelBound((Channel)channel, (SocketAddress)connectionLocalAddress);
                    ChannelAddress connectionRemoteAddress = connectionLocalAddress.newEphemeralAddress();
                    channel.setRemoteAddress(connectionRemoteAddress);
                    channel.setConnected();
                    Channels.fireChannelConnected((Channel)channel, (SocketAddress)connectionRemoteAddress);
                    httpConfig.setStatus(HttpResponseStatus.CREATED);
                    httpConfig.setMaximumBufferedContentLength(8192);
                    HttpHeaders httpWriteHeaders = httpConfig.getWriteHeaders();
                    httpWriteHeaders.set("Cache-Control", (Object)"no-cache");
                    httpWriteHeaders.set("Content-Type", (Object)"application/octet-stream");
                    httpWriteHeaders.set("Location", (Object)connectionPath);
                    httpWriteHeaders.set("X-Strategy", (Object)negotiatedStrategy.toString());
                    httpChannel.close();
                    final Channel httpBindChannel = httpBindFuture.getChannel();
                    channel.getCloseFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            httpBindChannel.close();
                        }
                    });
                } else {
                    channel.setClosed();
                    Channels.fireChannelClosed((Channel)channel);
                    httpConfig.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                    httpChannel.close();
                }
            }
        });
    }

    private static List<BBoshStrategy> readAcceptStrategies(HttpHeaders httpHeaders) {
        List strategyValues = httpHeaders.getAll("X-Accept-Strategy");
        ArrayList<BBoshStrategy> strategies = new ArrayList<BBoshStrategy>(3);
        for (String strategyValue : strategyValues) {
            String[] strategyValueParts;
            for (String strategyValuePart : strategyValueParts = strategyValue.split(",\\s+")) {
                BBoshStrategy strategy = BBoshStrategy.valueOf(strategyValuePart);
                strategies.add(strategy);
            }
        }
        return strategies;
    }
}

