/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.http;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.QueryStringEncoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.ChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownInputEvent;

public class HttpChildChannelSource
extends HttpChannelHandler {
    private final NavigableMap<ChannelAddress, HttpServerChannel> httpBindings;
    private volatile HttpChildChannel httpChildChannel;

    public HttpChildChannelSource(NavigableMap<ChannelAddress, HttpServerChannel> httpBindings) {
        this.httpBindings = httpBindings;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        HttpChildChannel httpChildChannel = this.httpChildChannel;
        if (httpChildChannel != null) {
            this.httpChildChannel = null;
            if (httpChildChannel.setReadClosed() || httpChildChannel.setWriteClosed()) {
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)httpChildChannel, (Throwable)e.getCause());
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
            }
        }
        Channel channel = ctx.getChannel();
        channel.close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HttpChildChannel httpChildChannel = this.httpChildChannel;
        if (httpChildChannel != null) {
            this.httpChildChannel = null;
            switch (httpChildChannel.readState()) {
                case UPGRADED: {
                    if (!httpChildChannel.setReadClosed()) break;
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
                    break;
                }
                case CONTENT_COMPLETE: {
                    break;
                }
                default: {
                    if (!httpChildChannel.setReadAborted()) break;
                    Channels.fireInputAborted((Channel)httpChildChannel);
                    httpChildChannel.setClosed();
                }
            }
        }
    }

    @Override
    public void inputShutdown(ChannelHandlerContext ctx, ShutdownInputEvent e) {
        HttpChildChannel httpChildChannel = this.httpChildChannel;
        if (httpChildChannel != null) {
            if (httpChildChannel.readState() == HttpChildChannel.HttpReadState.UPGRADED) {
                Channels.fireInputShutdown((Channel)httpChildChannel);
            }
        } else {
            Channels.abortOutput(ctx, org.jboss.netty.channel.Channels.future((Channel)e.getChannel()));
        }
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, HttpRequest httpRequest) throws Exception {
        HttpVersion version = httpRequest.getProtocolVersion();
        URI httpLocation = HttpChildChannelSource.getEffectiveURI(httpRequest);
        if (httpLocation == null) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, HttpResponseStatus.BAD_REQUEST);
            ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)ctx.getChannel());
            org.jboss.netty.channel.Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)httpResponse);
            return;
        }
        ChannelAddress transportCandidate = (ChannelAddress)ctx.getChannel().getParent().getAttachment();
        ChannelAddress candidate = new ChannelAddress(httpLocation, transportCandidate);
        Map.Entry<ChannelAddress, HttpServerChannel> httpBinding = this.httpBindings.floorEntry(candidate);
        if (httpBinding == null) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, HttpResponseStatus.NOT_FOUND);
            ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)ctx.getChannel());
            org.jboss.netty.channel.Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)httpResponse);
            return;
        }
        HttpServerChannel parent = httpBinding.getValue();
        ChannelFactory factory = parent.getFactory();
        ChannelConfig config = (ChannelConfig)parent.getConfig();
        ChannelPipelineFactory pipelineFactory = config.getPipelineFactory();
        ChannelPipeline pipeline = pipelineFactory.getPipeline();
        ChannelAddress httpLocalAddress = parent.getLocalAddress();
        Channel transport = ctx.getChannel();
        ChannelAddress remoteAddress = org.kaazing.k3po.driver.internal.channel.Channels.remoteAddress(transport);
        ChannelAddress httpRemoteAddress = new ChannelAddress(httpLocation, remoteAddress, true);
        HttpChildChannelSink sink = new HttpChildChannelSink(transport);
        HttpChildChannel httpChildChannel = new HttpChildChannel((ServerChannel)parent, factory, pipeline, (ChannelSink)sink);
        HttpChannelConfig httpChildConfig = (HttpChannelConfig)httpChildChannel.getConfig();
        httpChildConfig.setMethod(httpRequest.getMethod());
        httpChildConfig.setVersion(version);
        httpChildConfig.getReadHeaders().set(httpRequest.headers());
        httpChildConfig.setReadQuery(new QueryStringDecoder(httpRequest.getUri()));
        httpChildConfig.setWriteQuery(new QueryStringEncoder(httpRequest.getUri()));
        httpChildConfig.setStatus(HttpResponseStatus.OK);
        transport.getConfig().setBufferFactory(httpChildConfig.getBufferFactory());
        this.httpChildChannel = httpChildChannel;
        this.detectWriteTransportClosed(transport, httpChildChannel);
        ChannelBuffer content = httpRequest.getContent();
        if (HttpHeaders.isTransferEncodingChunked((HttpMessage)httpRequest)) {
            httpChildChannel.readState(HttpChildChannel.HttpReadState.CONTENT_CHUNKED);
        } else if (HttpHeaders.isContentLengthSet((HttpMessage)httpRequest)) {
            long contentLength = HttpHeaders.getContentLength((HttpMessage)httpRequest);
            if ((contentLength -= (long)content.readableBytes()) > 0L) {
                httpChildChannel.readState(HttpChildChannel.HttpReadState.CONTENT_CHUNKED);
            } else {
                httpChildChannel.readState(HttpChildChannel.HttpReadState.CONTENT_COMPLETE);
            }
        } else {
            httpChildChannel.readState(HttpChildChannel.HttpReadState.CONTENT_COMPLETE);
        }
        org.jboss.netty.channel.Channels.fireChannelOpen((Channel)httpChildChannel);
        httpChildChannel.setLocalAddress(httpLocalAddress);
        httpChildChannel.setBound();
        org.jboss.netty.channel.Channels.fireChannelBound((Channel)httpChildChannel, (SocketAddress)httpLocalAddress);
        httpChildChannel.setRemoteAddress(httpRemoteAddress);
        httpChildChannel.setConnected();
        org.jboss.netty.channel.Channels.fireChannelConnected((Channel)httpChildChannel, (SocketAddress)httpRemoteAddress);
        if (content.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)httpChildChannel, (Object)content);
        }
        if (httpChildConfig.getStatus().getCode() == HttpResponseStatus.SWITCHING_PROTOCOLS.getCode()) {
            httpChildChannel.readState(HttpChildChannel.HttpReadState.UPGRADED);
        }
        switch (httpChildChannel.readState()) {
            case CONTENT_COMPLETE: {
                Channels.fireInputShutdown((Channel)httpChildChannel);
                this.httpChildChannel = null;
                if (!httpChildChannel.setReadClosed()) break;
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
                break;
            }
        }
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, HttpChunk chunk) throws Exception {
        boolean last;
        ChannelBuffer content = chunk.getContent();
        if (content.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.httpChildChannel, (Object)content);
        }
        if (last = chunk.isLast()) {
            HttpHeaders trailingHeaders = ((HttpChunkTrailer)chunk).trailingHeaders();
            ((HttpChannelConfig)this.httpChildChannel.getConfig()).getReadTrailers().add(trailingHeaders);
            HttpChildChannel httpChildChannel = this.httpChildChannel;
            httpChildChannel.readState(HttpChildChannel.HttpReadState.CONTENT_COMPLETE);
            this.httpChildChannel = null;
            Channels.fireInputShutdown((Channel)httpChildChannel);
            if (httpChildChannel.setReadClosed()) {
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
            }
        }
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, ChannelBuffer message) throws Exception {
        if (message.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.httpChildChannel, (Object)message);
        }
    }

    private static URI getEffectiveURI(HttpRequest httpRequest) {
        URI requestURI = URI.create(httpRequest.getUri());
        if (requestURI.isAbsolute()) {
            return requestURI;
        }
        String host = HttpHeaders.getHost((HttpMessage)httpRequest);
        return host != null ? URI.create(String.format("http://%s%s", host, requestURI)) : null;
    }

    private void detectWriteTransportClosed(final Channel transport, final HttpChildChannel httpChildChannel) {
        Objects.requireNonNull(httpChildChannel);
        final ChannelFutureListener closeListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                switch (httpChildChannel.writeState()) {
                    case UPGRADED: 
                    case CONTENT_CLOSING: {
                        if (!httpChildChannel.setWriteClosed()) break;
                        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
                        break;
                    }
                    case CONTENT_COMPLETE: {
                        break;
                    }
                    default: {
                        if (!httpChildChannel.setReadAborted()) break;
                        Channels.fireInputAborted((Channel)httpChildChannel);
                        httpChildChannel.setClosed();
                    }
                }
            }
        };
        transport.getCloseFuture().addListener(closeListener);
        httpChildChannel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                transport.getCloseFuture().removeListener(closeListener);
            }
        });
    }
}

