/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.http;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractServerChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.ChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannelPipelineFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public class HttpServerChannelSink
extends AbstractServerChannelSink<HttpServerChannel> {
    private final ConcurrentNavigableMap<ChannelAddress, HttpServerChannel> httpBindings;
    private final ConcurrentMap<ChannelAddress, HttpTransport> httpTransports;
    private final ChannelPipelineFactory pipelineFactory;

    public HttpServerChannelSink() {
        this(new ConcurrentSkipListMap<ChannelAddress, HttpServerChannel>(ChannelAddress.ADDRESS_COMPARATOR));
    }

    private HttpServerChannelSink(ConcurrentNavigableMap<ChannelAddress, HttpServerChannel> httpBindings) {
        this.pipelineFactory = new HttpChildChannelPipelineFactory(httpBindings);
        this.httpBindings = httpBindings;
        this.httpTransports = new ConcurrentHashMap();
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelAddress address;
        HttpTransport httpTransport;
        final HttpServerChannel httpBindChannel = (HttpServerChannel)evt.getChannel();
        final ChannelFuture httpBindFuture = evt.getFuture();
        final ChannelAddress httpLocalAddress = (ChannelAddress)evt.getValue();
        URI httpLocation = httpLocalAddress.getLocation();
        HttpServerChannel httpBoundChannel = this.httpBindings.putIfAbsent(httpLocalAddress, httpBindChannel);
        if (httpBoundChannel != null) {
            httpBindFuture.setFailure((Throwable)new ChannelException(String.format("Duplicate bind failed: %s", httpLocation)));
        }
        if ((httpTransport = (HttpTransport)this.httpTransports.get(address = httpLocalAddress.getTransport())) == null) {
            String schemeName = address.getLocation().getScheme();
            String httpSchemeName = httpLocalAddress.getLocation().getScheme();
            ServerBootstrap bootstrap = this.bootstrapFactory.newServerBootstrap(schemeName);
            bootstrap.setParentHandler(this.createParentHandler(httpBindChannel, address));
            bootstrap.setPipelineFactory(this.pipelineFactory);
            bootstrap.setOptions(((ChannelConfig)httpBindChannel.getConfig()).getTransportOptions());
            bootstrap.setOption(String.format("%s.nextProtocol", schemeName), httpSchemeName);
            ChannelFuture bindFuture = bootstrap.bindAsync(address);
            HttpTransport newHttpTransport = new HttpTransport(bindFuture, 1);
            httpTransport = this.httpTransports.putIfAbsent(address, newHttpTransport);
            if (httpTransport == null) {
                httpTransport = newHttpTransport;
            }
        } else {
            httpTransport.count.incrementAndGet();
        }
        if (httpTransport.future.isDone()) {
            HttpServerChannelSink.handleHttpTransportBindComplete(httpBindChannel, httpBindFuture, httpLocalAddress, httpTransport.future);
        } else {
            httpTransport.future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    HttpServerChannelSink.handleHttpTransportBindComplete(httpBindChannel, httpBindFuture, httpLocalAddress, future);
                }
            });
        }
    }

    @Override
    protected void unbindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final HttpServerChannel httpUnbindChannel = (HttpServerChannel)evt.getChannel();
        final ChannelFuture httpUnbindFuture = evt.getFuture();
        ChannelAddress httpLocalAddress = httpUnbindChannel.getLocalAddress();
        if (!this.httpBindings.remove(httpLocalAddress, (Object)httpUnbindChannel)) {
            httpUnbindFuture.setFailure((Throwable)new ChannelException("Channel not bound"));
            return;
        }
        ChannelAddress address = httpLocalAddress.getTransport();
        HttpTransport httpTransport = (HttpTransport)this.httpTransports.get(address);
        assert (httpTransport != null);
        if (httpTransport.count.decrementAndGet() == 0) {
            HttpTransport oldHttpTransport = new HttpTransport(httpTransport.future);
            if (this.httpTransports.remove(address, oldHttpTransport)) {
                Channel transport = httpUnbindChannel.getTransport();
                ChannelFuture unbindFuture = transport.unbind();
                if (unbindFuture.isDone()) {
                    HttpServerChannelSink.handleHttpTransportUnbindComplete(httpUnbindChannel, httpUnbindFuture, unbindFuture);
                } else {
                    unbindFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture unbindFuture) throws Exception {
                            HttpServerChannelSink.handleHttpTransportUnbindComplete(httpUnbindChannel, httpUnbindFuture, unbindFuture);
                        }
                    });
                }
            }
        } else {
            Channels.fireChannelUnbound((Channel)httpUnbindChannel);
            httpUnbindFuture.setSuccess();
        }
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final HttpServerChannel httpCloseChannel = (HttpServerChannel)evt.getChannel();
        final ChannelFuture httpCloseFuture = evt.getFuture();
        boolean wasBound = httpCloseChannel.isBound();
        if (!httpCloseFuture.isDone()) {
            Channel transport;
            if (wasBound) {
                this.unbindRequested(pipeline, evt);
            }
            if ((transport = httpCloseChannel.getTransport()) != null) {
                ChannelFuture closeFuture = transport.close();
                if (closeFuture.isDone()) {
                    HttpServerChannelSink.handleHttpTransportCloseComplete(httpCloseChannel, httpCloseFuture, closeFuture);
                } else {
                    closeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture closeFuture) throws Exception {
                            HttpServerChannelSink.handleHttpTransportCloseComplete(httpCloseChannel, httpCloseFuture, closeFuture);
                        }
                    });
                }
            }
        }
    }

    private ChannelHandler createParentHandler(HttpServerChannel channel, final ChannelAddress address) {
        return new SimpleChannelHandler(){
            private final ChannelGroup childChannels = new DefaultChannelGroup();

            public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                e.getChannel().setAttachment((Object)address);
                this.childChannels.add((Object)e.getChildChannel());
                super.childChannelOpen(ctx, e);
            }

            public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                this.childChannels.remove((Object)e.getChildChannel());
                super.childChannelClosed(ctx, e);
            }

            public void closeRequested(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
                this.childChannels.close().addListener(new ChannelGroupFutureListener(){

                    public void operationComplete(ChannelGroupFuture future) throws Exception {
                        ctx.sendDownstream((ChannelEvent)e);
                    }
                });
            }
        };
    }

    private static void handleHttpTransportBindComplete(HttpServerChannel httpBindChannel, ChannelFuture httpBindFuture, ChannelAddress httpLocalAddress, ChannelFuture bindFuture) {
        if (bindFuture.isSuccess()) {
            httpBindChannel.setTransport(bindFuture.getChannel());
            httpBindChannel.setLocalAddress(httpLocalAddress);
            httpBindChannel.setBound();
            Channels.fireChannelBound((Channel)httpBindChannel, (SocketAddress)httpBindChannel.getLocalAddress());
            httpBindFuture.setSuccess();
        } else {
            httpBindFuture.setFailure(bindFuture.getCause());
        }
    }

    private static void handleHttpTransportUnbindComplete(HttpServerChannel httpUnbindChannel, ChannelFuture httpUnbindFuture, ChannelFuture unbindFuture) {
        if (unbindFuture.isSuccess()) {
            Channels.fireChannelUnbound((Channel)httpUnbindChannel);
            httpUnbindFuture.setSuccess();
        } else {
            httpUnbindFuture.setFailure(unbindFuture.getCause());
        }
    }

    private static void handleHttpTransportCloseComplete(HttpServerChannel httpCloseChannel, ChannelFuture httpCloseFuture, ChannelFuture closeFuture) {
        if (closeFuture.isSuccess()) {
            Channels.fireChannelClosed((Channel)httpCloseChannel);
            httpCloseChannel.setClosed();
        } else {
            httpCloseFuture.setFailure(closeFuture.getCause());
        }
    }

    private static final class HttpTransport {
        final ChannelFuture future;
        final AtomicInteger count;

        HttpTransport(ChannelFuture future) {
            this(future, 0);
        }

        HttpTransport(ChannelFuture future, int count) {
            this.future = future;
            this.count = new AtomicInteger(count);
        }

        public int hashCode() {
            return Objects.hash(this.future, this.count);
        }

        public boolean equals(Object obj) {
            HttpTransport that = (HttpTransport)obj;
            return Objects.equals(this.future, that.future) && this.count.get() == that.count.get();
        }

        public String toString() {
            return String.format("[future=@%d, count=%d]", Objects.hashCode(this.future), this.count.get());
        }
    }
}

