/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.udp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineException;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.kaazing.k3po.driver.internal.executor.ExecutorServiceFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactorySpi;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpIdleHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpServerChannelFactory;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.udp.UdpChannelAddress;

public final class UdpBootstrapFactorySpi
extends BootstrapFactorySpi
implements ExternalResourceReleasable {
    private final Collection<ChannelFactory> channelFactories = new ConcurrentLinkedDeque<ChannelFactory>();
    private ExecutorServiceFactory executorServiceFactory;
    private NioDatagramChannelFactory clientChannelFactory;
    private UdpServerChannelFactory serverChannelFactory;
    private final Timer timer = new HashedWheelTimer();

    @Resource
    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    @Override
    public String getTransportName() {
        return "udp";
    }

    @Override
    public void shutdown() {
        for (ChannelFactory channelFactory : this.channelFactories) {
            channelFactory.shutdown();
        }
    }

    @Override
    public void releaseExternalResources() {
        for (ChannelFactory channelFactory : this.channelFactories) {
            channelFactory.releaseExternalResources();
        }
        this.timer.stop();
    }

    @Override
    public synchronized ClientBootstrap newClientBootstrap() throws Exception {
        if (this.clientChannelFactory == null) {
            ExecutorService workerExecutor = this.executorServiceFactory.newExecutorService("worker.client");
            NioDatagramWorkerPool workerPool = new NioDatagramWorkerPool((Executor)workerExecutor, 1);
            this.clientChannelFactory = new NioDatagramChannelFactory((WorkerPool)workerPool);
            this.channelFactories.add((ChannelFactory)this.clientChannelFactory);
        }
        return new UdpClientBootstrap((ChannelFactory)this.clientChannelFactory, this.timer);
    }

    @Override
    public synchronized ServerBootstrap newServerBootstrap() throws Exception {
        if (this.serverChannelFactory == null) {
            ExecutorService workerExecutor = this.executorServiceFactory.newExecutorService("worker.server");
            NioDatagramWorkerPool workerPool = new NioDatagramWorkerPool((Executor)workerExecutor, 1);
            this.serverChannelFactory = new UdpServerChannelFactory(workerPool, this.timer);
            this.channelFactories.add((ChannelFactory)this.serverChannelFactory);
        }
        return new ServerBootstrap((ChannelFactory)this.serverChannelFactory);
    }

    private static InetSocketAddress toInetSocketAddress(ChannelAddress channelAddress) {
        if (channelAddress == null) {
            return null;
        }
        URI location = channelAddress.getLocation();
        String hostname = location.getHost();
        int port = location.getPort();
        return new InetSocketAddress(hostname, port);
    }

    private static class UdpClientBootstrap
    extends ClientBootstrap {
        private final Timer timer;

        UdpClientBootstrap(ChannelFactory channelFactory, Timer timer) {
            super(channelFactory);
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelFuture connect(SocketAddress remoteChannelAddress, SocketAddress localChannelAddress) {
            ChannelPipeline pipeline;
            InetSocketAddress localAddress = UdpBootstrapFactorySpi.toInetSocketAddress((ChannelAddress)localChannelAddress);
            InetSocketAddress remoteAddress = UdpBootstrapFactorySpi.toInetSocketAddress((ChannelAddress)remoteChannelAddress);
            if (remoteAddress == null) {
                throw new NullPointerException("remoteAddress");
            }
            try {
                pipeline = this.getPipelineFactory().getPipeline();
            }
            catch (Exception e) {
                throw new ChannelPipelineException("Failed to initialize a pipeline.", (Throwable)e);
            }
            long timeout = ((UdpChannelAddress)remoteChannelAddress).timeout();
            if (timeout != 0L) {
                IdleStateHandler idleStateHandler = new IdleStateHandler(this.timer, 0L, 0L, timeout, TimeUnit.MILLISECONDS);
                pipeline.addFirst("idleHandler", (ChannelHandler)new UdpIdleHandler());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)idleStateHandler);
            }
            this.setPipeline(pipeline);
            Channel ch = this.getFactory().newChannel(pipeline);
            boolean success = false;
            try {
                ch.getConfig().setOptions(this.getOptions());
                success = true;
            }
            finally {
                if (!success) {
                    ch.close();
                }
            }
            if (localAddress != null) {
                ch.bind((SocketAddress)localAddress);
            }
            return ch.connect((SocketAddress)remoteAddress);
        }
    }
}

