/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.types;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;
import org.kaazing.k3po.lang.types.TypeSystemSpi;

public final class HttpTypeSystem
implements TypeSystemSpi {
    public static final TypeInfo<URI> OPTION_TRANSPORT = new TypeInfo("transport", URI.class);
    public static final TypeInfo<String> OPTION_CHUNK_EXT = new TypeInfo("chunkExtension", String.class);
    public static final StructuredTypeInfo CONFIG_METHOD = new StructuredTypeInfo("http", "method", Collections.emptyList(), 1);
    public static final StructuredTypeInfo CONFIG_HEADER = new StructuredTypeInfo("http", "header", Collections.singletonList(new TypeInfo("name", String.class)), Integer.MAX_VALUE);
    public static final StructuredTypeInfo CONFIG_PARAMETER = new StructuredTypeInfo("http", "parameter", Collections.singletonList(new TypeInfo("name", String.class)), Integer.MAX_VALUE);
    public static final StructuredTypeInfo CONFIG_STATUS = new StructuredTypeInfo("http", "status", Arrays.asList(new TypeInfo("code", String.class), new TypeInfo("reason", String.class)), 0);
    public static final StructuredTypeInfo CONFIG_VERSION = new StructuredTypeInfo("http", "version", Collections.emptyList(), 1);
    public static final StructuredTypeInfo CONFIG_TRAILER = new StructuredTypeInfo("http", "trailer", Collections.singletonList(new TypeInfo("name", String.class)), Integer.MAX_VALUE);
    public static final StructuredTypeInfo CONFIG_REQUEST = new StructuredTypeInfo("http", "request", Collections.emptyList(), 1);
    public static final StructuredTypeInfo CONFIG_HOST = new StructuredTypeInfo("http", "host", Collections.emptyList(), 0);
    public static final StructuredTypeInfo CONFIG_CONTENT_LENGTH = new StructuredTypeInfo("http", "content-length", Collections.emptyList(), 0);
    private final Set<TypeInfo<?>> acceptOptions = Collections.singleton(OPTION_TRANSPORT);
    private final Set<TypeInfo<?>> connectOptions = Collections.singleton(OPTION_TRANSPORT);
    private final Set<TypeInfo<?>> readOptions = Collections.singleton(OPTION_CHUNK_EXT);
    private final Set<TypeInfo<?>> writeOptions = Collections.singleton(OPTION_CHUNK_EXT);
    private final Set<StructuredTypeInfo> readConfigs;
    private final Set<StructuredTypeInfo> writeConfigs;

    public HttpTypeSystem() {
        LinkedHashSet<StructuredTypeInfo> readConfigs = new LinkedHashSet<StructuredTypeInfo>();
        readConfigs.add(CONFIG_METHOD);
        readConfigs.add(CONFIG_HEADER);
        readConfigs.add(CONFIG_PARAMETER);
        readConfigs.add(CONFIG_STATUS);
        readConfigs.add(CONFIG_VERSION);
        readConfigs.add(CONFIG_TRAILER);
        this.readConfigs = readConfigs;
        LinkedHashSet<StructuredTypeInfo> writeConfigs = new LinkedHashSet<StructuredTypeInfo>();
        writeConfigs.add(CONFIG_REQUEST);
        writeConfigs.add(CONFIG_METHOD);
        writeConfigs.add(CONFIG_HEADER);
        writeConfigs.add(CONFIG_PARAMETER);
        writeConfigs.add(CONFIG_STATUS);
        writeConfigs.add(CONFIG_VERSION);
        writeConfigs.add(CONFIG_TRAILER);
        writeConfigs.add(CONFIG_HOST);
        writeConfigs.add(CONFIG_CONTENT_LENGTH);
        this.writeConfigs = writeConfigs;
    }

    public String getName() {
        return "http";
    }

    public Set<TypeInfo<?>> acceptOptions() {
        return this.acceptOptions;
    }

    public Set<TypeInfo<?>> connectOptions() {
        return this.connectOptions;
    }

    public Set<TypeInfo<?>> readOptions() {
        return this.readOptions;
    }

    public Set<TypeInfo<?>> writeOptions() {
        return this.writeOptions;
    }

    public Set<StructuredTypeInfo> readConfigs() {
        return this.readConfigs;
    }

    public Set<StructuredTypeInfo> writeConfigs() {
        return this.writeConfigs;
    }
}

