/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.ShareableWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.Robot;
import org.kaazing.k3po.driver.internal.control.handler.ControlDecoder;
import org.kaazing.k3po.driver.internal.control.handler.ControlEncoder;
import org.kaazing.k3po.driver.internal.control.handler.ControlServerHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;

public class RobotServer {
    private final ChannelGroup channelGroup;
    private final List<ControlServerHandler> controlHandlers;
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(RobotServer.class);
    private BootstrapFactory bootstrapFactory;
    private final URI controlURI;
    private Channel serverChannel;
    private final boolean verbose;
    private final ClassLoader scriptLoader;
    private ShareableWorkerPool<NioWorker> sharedWorkerPool;
    private NioClientSocketChannelFactory clientChannelFactory;
    private NioServerSocketChannelFactory serverChannelFactory;
    private AtomicReference<Robot> activeRobotRef = new AtomicReference<Object>(null);

    public RobotServer(URI controlURI, boolean verbose, ClassLoader scriptLoader) {
        this.controlURI = controlURI;
        this.verbose = verbose;
        this.scriptLoader = scriptLoader;
        this.channelGroup = new DefaultChannelGroup("robot-server");
        this.controlHandlers = new CopyOnWriteArrayList<ControlServerHandler>();
    }

    public void start() throws Exception {
        if (this.controlURI == null) {
            throw new NullPointerException("controlURI");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        ChannelAddressFactory addressFactory = ChannelAddressFactory.newChannelAddressFactory();
        ChannelAddress localAddress = addressFactory.newChannelAddress(this.controlURI, options);
        NioClientBossPool clientBossPool = new NioClientBossPool((Executor)Executors.newCachedThreadPool(), 1);
        NioServerBossPool serverBossPool = new NioServerBossPool((Executor)Executors.newCachedThreadPool(), 1);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(), 1);
        this.sharedWorkerPool = new ShareableWorkerPool((WorkerPool)workerPool);
        this.clientChannelFactory = new NioClientSocketChannelFactory((BossPool)clientBossPool, this.sharedWorkerPool);
        this.serverChannelFactory = new NioServerSocketChannelFactory((BossPool)serverBossPool, this.sharedWorkerPool);
        HashMap injectables = new HashMap();
        injectables.put(ChannelAddressFactory.class, addressFactory);
        injectables.put(NioClientSocketChannelFactory.class, this.clientChannelFactory);
        injectables.put(NioServerSocketChannelFactory.class, this.serverChannelFactory);
        this.bootstrapFactory = BootstrapFactory.newBootstrapFactory(injectables);
        String transportName = this.controlURI.getScheme();
        ServerBootstrap server = this.bootstrapFactory.newServerBootstrap(transportName);
        server.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                ControlDecoder decoder = new ControlDecoder();
                pipeline.addLast("control.decoder", (ChannelHandler)decoder);
                ControlEncoder encoder = new ControlEncoder();
                pipeline.addLast("control.encoder", (ChannelHandler)encoder);
                if (RobotServer.this.verbose) {
                    LoggingHandler logging = new LoggingHandler("robot.server", false);
                    pipeline.addLast("control.logging", (ChannelHandler)logging);
                }
                ControlServerHandler controller = new ControlServerHandler(RobotServer.this.activeRobotRef);
                controller.setScriptLoader(RobotServer.this.scriptLoader);
                pipeline.addLast("control.handler", (ChannelHandler)controller);
                return pipeline;
            }
        });
        server.setParentHandler((ChannelHandler)new SimpleChannelHandler(){

            public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                LOGGER.debug("Control Channel Opened");
                Channel childChannel = e.getChildChannel();
                RobotServer.this.channelGroup.add((Object)childChannel);
                final ControlServerHandler controller = (ControlServerHandler)childChannel.getPipeline().getContext("control.handler").getHandler();
                RobotServer.this.controlHandlers.add(controller);
                controller.getChannelClosedFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        RobotServer.this.controlHandlers.remove((Object)controller);
                    }
                });
            }
        });
        this.serverChannel = server.bind(localAddress);
    }

    public void stop() throws TimeoutException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly(2000L);
            if (isDebugEnabled) {
                LOGGER.debug("Server control channel closed.");
            }
        }
        this.channelGroup.close().awaitUninterruptibly(2000L);
        if (isDebugEnabled) {
            LOGGER.debug("Control channels closed.");
        }
        for (ControlServerHandler controller : this.controlHandlers) {
            controller.getChannelClosedFuture().awaitUninterruptibly(2000L);
        }
        if (this.clientChannelFactory != null) {
            LOGGER.debug("Releasing tcp client channel factory");
            this.clientChannelFactory.shutdown();
            this.clientChannelFactory.releaseExternalResources();
            LOGGER.debug("Released tcp client channel factory");
        }
        if (this.serverChannelFactory != null) {
            LOGGER.debug("Releasing tcp server channel factory");
            this.serverChannelFactory.shutdown();
            this.serverChannelFactory.releaseExternalResources();
            LOGGER.debug("Released tcp server channel factory");
        }
        if (this.sharedWorkerPool != null) {
            LOGGER.debug("Destroying shared worker pool");
            this.sharedWorkerPool.destroy();
            LOGGER.debug("Destroyed shared worker pool.");
        }
        if (this.bootstrapFactory != null) {
            LOGGER.debug("Releasing external resources");
            this.bootstrapFactory.releaseExternalResources();
            LOGGER.debug("External resources released.");
        }
    }

    public void join() throws InterruptedException {
        if (this.serverChannel != null) {
            this.serverChannel.getCloseFuture().await();
        }
    }
}

