/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import java.nio.ByteOrder;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.lang.internal.RegionInfo;

public abstract class MessageDecoder {
    private final RegionInfo regionInfo;
    private ChannelBuffer cumulation;

    protected MessageDecoder(RegionInfo regionInfo) {
        this.regionInfo = Objects.requireNonNull(regionInfo);
    }

    public ChannelBuffer decodeLast(ChannelBuffer buffer) throws Exception {
        return this.decode0(buffer, true);
    }

    public ChannelBuffer decode(ChannelBuffer buffer) throws Exception {
        return this.decode0(buffer, false);
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    private ChannelBuffer decode0(ChannelBuffer buffer, boolean isLast) throws Exception {
        try {
            if (this.cumulation == null) {
                this.cumulation = ChannelBuffers.dynamicBuffer((ByteOrder)buffer.order(), (int)256);
            }
            this.cumulation.writeBytes(buffer);
            Object decoded = isLast ? this.decodeBufferLast(this.cumulation) : this.decodeBuffer(this.cumulation);
            if (decoded == null) {
                return null;
            }
            ChannelBuffer remaining = ChannelBuffers.EMPTY_BUFFER;
            if (this.cumulation.readable()) {
                remaining = this.cumulation.readBytes(this.cumulation.readableBytes());
            }
            this.cumulation = null;
            return remaining;
        }
        catch (ScriptProgressException e) {
            this.cumulation = null;
            throw e;
        }
    }

    protected ChannelBuffer createCumulationBuffer(ChannelHandlerContext ctx) {
        return ChannelBuffers.dynamicBuffer();
    }

    protected Object decodeBufferLast(ChannelBuffer buffer) throws Exception {
        return this.decodeBuffer(buffer);
    }

    protected abstract Object decodeBuffer(ChannelBuffer var1) throws Exception;
}

