/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.util.Utils;
import org.kaazing.k3po.lang.el.BytesMatcher;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public class ReadExpressionDecoder
extends MessageDecoder {
    private final ValueExpression expression;
    private final ExpressionContext environment;
    private BytesMatcher matcher;

    public ReadExpressionDecoder(RegionInfo regionInfo, ValueExpression expression, ExpressionContext environment) {
        super(regionInfo);
        this.expression = expression;
        this.environment = environment;
    }

    public String toString() {
        return this.expression.getExpressionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        Object read;
        Object expected;
        ExpressionContext expressionContext = this.environment;
        synchronized (expressionContext) {
            expected = this.expression.getValue((ELContext)this.environment);
        }
        if (this.matcher == null && expected instanceof BytesMatcher) {
            this.matcher = (BytesMatcher)expected;
        }
        if (this.matcher != null) {
            ByteBuffer byteBuf = buffer.toByteBuffer();
            int initialPos = byteBuf.position();
            try {
                read = this.matcher.match(byteBuf);
            }
            catch (Exception ex) {
                throw new ScriptProgressException(this.getRegionInfo(), ex.getMessage());
            }
            int bytesAdvanced = byteBuf.position() - initialPos;
            buffer.skipBytes(bytesAdvanced);
        } else {
            read = this.readValue(buffer, expected);
        }
        if (read == null) {
            return null;
        }
        return buffer;
    }

    ReadExpressionDecoder(ValueExpression expression, ExpressionContext environment) {
        this(RegionInfo.newSequential((int)0, (int)0), expression, environment);
    }

    private Object readValue(ChannelBuffer buffer, Object expected) throws ScriptProgressException {
        Object observed = null;
        int available = buffer.readableBytes();
        if (expected instanceof byte[] || expected instanceof String) {
            observed = this.readByteArrayOrString(buffer, expected);
        } else {
            if (expected instanceof Long && available >= 8) {
                observed = this.readLong(buffer, (Long)expected);
            } else if (expected instanceof Integer && available >= 4) {
                observed = this.readInteger(buffer, (Integer)expected);
            } else if (expected instanceof Short && available >= 2) {
                observed = this.readShort(buffer, (Short)expected);
            } else if (expected instanceof Byte && available >= 1) {
                observed = this.readByte(buffer, (Byte)expected);
            } else {
                throw new ScriptProgressException(this.getRegionInfo(), String.format("Expected value %s has unsupported type", expected));
            }
            if (observed != null && !expected.equals(observed)) {
                throw new ScriptProgressException(this.getRegionInfo(), observed.toString());
            }
        }
        return observed;
    }

    private Object readByteArrayOrString(ChannelBuffer buffer, Object expected) throws ScriptProgressException {
        byte[] expectedBytes = expected instanceof String ? ((String)expected).getBytes(StandardCharsets.UTF_8) : (byte[])expected;
        byte[] read = this.readByteArray(buffer, expectedBytes);
        if (read != null && !Arrays.equals(read, expectedBytes)) {
            throw new ScriptProgressException(this.getRegionInfo(), Utils.format(read));
        }
        byte[] observed = read;
        return observed;
    }

    private byte[] readByteArray(ChannelBuffer buffer, byte[] expected) {
        byte[] result = null;
        if (buffer.readableBytes() >= expected.length) {
            result = new byte[expected.length];
            buffer.readBytes(result);
        }
        return result;
    }

    private Byte readByte(ChannelBuffer buffer, Byte expected) {
        Byte result = null;
        int length = 1;
        if (buffer.readableBytes() >= length) {
            int index = buffer.readerIndex();
            result = buffer.getByte(buffer.readerIndex());
            buffer.readerIndex(index + length);
        }
        return result;
    }

    private Short readShort(ChannelBuffer buffer, Short expected) {
        Short result = null;
        int length = 2;
        if (buffer.readableBytes() >= length) {
            int index = buffer.readerIndex();
            result = buffer.getShort(buffer.readerIndex());
            buffer.readerIndex(index + length);
        }
        return result;
    }

    private Integer readInteger(ChannelBuffer buffer, Integer expected) {
        Integer result = null;
        int length = 4;
        if (buffer.readableBytes() >= length) {
            int index = buffer.readerIndex();
            result = buffer.getInt(buffer.readerIndex());
            buffer.readerIndex(index + length);
        }
        return result;
    }

    private Long readLong(ChannelBuffer buffer, Long expected) {
        Long result = null;
        int length = 8;
        if (buffer.readableBytes() >= length) {
            int index = buffer.readerIndex();
            result = buffer.getLong(buffer.readerIndex());
            buffer.readerIndex(index + length);
        }
        return result;
    }
}

