/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import org.jboss.netty.buffer.ChannelBuffer;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ReadNumberDecoder
extends MessageDecoder {
    private final Number expected;

    public ReadNumberDecoder(RegionInfo regionInfo, Number expected) {
        super(regionInfo);
        this.expected = expected;
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (this.expected instanceof Short) {
            return this.decodeBufferAsShort(buffer);
        }
        if (this.expected instanceof Integer) {
            return this.decodeBufferAsInteger(buffer);
        }
        if (this.expected instanceof Long) {
            return this.decodeBufferAsLong(buffer);
        }
        throw new ScriptProgressException(this.getRegionInfo(), String.format("Unsupported type: %s", this.expected.getClass().getName()));
    }

    private Object decodeBufferAsShort(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        short observed = buffer.readShort();
        if (observed != this.expected.shortValue()) {
            throw new ScriptProgressException(this.getRegionInfo(), Short.toString(observed));
        }
        return buffer;
    }

    private Object decodeBufferAsInteger(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        int observed = buffer.readInt();
        if (observed != this.expected.intValue()) {
            throw new ScriptProgressException(this.getRegionInfo(), Integer.toString(observed));
        }
        return buffer;
    }

    private Object decodeBufferAsLong(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 8) {
            return null;
        }
        long observed = buffer.readLong();
        if (observed != this.expected.longValue()) {
            throw new ScriptProgressException(this.getRegionInfo(), Long.toString(observed));
        }
        return buffer;
    }

    public String toString() {
        return this.expected.toString();
    }

    ReadNumberDecoder(Number expected) {
        this(RegionInfo.newSequential((int)0, (int)0), expected);
    }
}

