/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralBytesValue;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public class ReadVariableLengthBytesDecoder
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadVariableLengthBytesDecoder.class);
    private final ValueExpression length;
    private final ExpressionContext environment;
    private final String captureName;

    public ReadVariableLengthBytesDecoder(RegionInfo regionInfo, ValueExpression length, ExpressionContext environment) {
        this(regionInfo, length, environment, null);
    }

    public ReadVariableLengthBytesDecoder(RegionInfo regionInfo, ValueExpression length, ExpressionContext environment, String captureName) {
        super(regionInfo);
        this.length = length;
        this.environment = environment;
        this.captureName = captureName;
    }

    public String toString() {
        return String.format("%s bytes", this.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        int resolvedLength;
        ExpressionContext expressionContext = this.environment;
        synchronized (expressionContext) {
            resolvedLength = (Integer)this.length.getValue((ELContext)this.environment);
        }
        if (buffer.readableBytes() < resolvedLength) {
            return null;
        }
        if (this.captureName == null) {
            buffer.readSlice(resolvedLength);
        } else {
            byte[] bytes = new byte[resolvedLength];
            buffer.readBytes(bytes, 0, resolvedLength);
            ExpressionContext expressionContext2 = this.environment;
            synchronized (expressionContext2) {
                this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)this.captureName, (Object)bytes);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Setting value for ${%s} to %s", this.captureName, AstLiteralBytesValue.toString((byte[])bytes)));
            }
        }
        return buffer;
    }

    ReadVariableLengthBytesDecoder(ValueExpression length, ExpressionContext environment) {
        this(RegionInfo.newSequential((int)0, (int)0), length, environment);
    }

    ReadVariableLengthBytesDecoder(ValueExpression length, ExpressionContext environment, String captureName) {
        this(RegionInfo.newSequential((int)0, (int)0), length, environment, captureName);
    }
}

