/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.AbstractConfigDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpHeaderDecoder
extends AbstractConfigDecoder {
    private String name;
    private List<MessageDecoder> valueDecoders;

    public HttpHeaderDecoder(String name, List<MessageDecoder> valueDecoders) {
        this.name = name;
        this.valueDecoders = valueDecoders;
    }

    @Override
    public boolean decode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        HttpHeaders headers = httpConfig.getReadHeaders();
        List headerValues = headers.getAll(this.name);
        if (this.valueDecoders.size() == 1) {
            MessageDecoder valueDecoder = this.valueDecoders.get(0);
            this.decodeHeaderValue(headers, headerValues, valueDecoder);
        } else {
            for (MessageDecoder valueDecoder : this.valueDecoders) {
                this.decodeHeaderValue(headers, headerValues, valueDecoder);
            }
        }
        return true;
    }

    public String toString() {
        return String.format("http:header %s %s", this.name, this.valueDecoders);
    }

    private void decodeHeaderValue(HttpHeaders headers, List<String> headerValues, MessageDecoder valueDecoder) throws Exception {
        int headerValueCount = headerValues.size();
        if (headerValueCount == 0) {
            throw new ScriptProgressException(this.getRegionInfo(), String.format("Missing HTTP header: %s", this.name));
        }
        if (headerValueCount == 1) {
            String headerValue = headerValues.get(0);
            valueDecoder.decodeLast(ChannelBuffers.copiedBuffer((CharSequence)headerValue, (Charset)CharsetUtil.UTF_8));
        } else {
            Exception decodeFailure = null;
            Iterator<String> $i = headerValues.iterator();
            while ($i.hasNext()) {
                String headerValue = $i.next();
                try {
                    valueDecoder.decodeLast(ChannelBuffers.copiedBuffer((CharSequence)headerValue, (Charset)CharsetUtil.UTF_8));
                    $i.remove();
                    break;
                }
                catch (Exception e) {
                    decodeFailure = e;
                }
            }
            if (headerValues.size() != headerValueCount) {
                headers.set(this.name, headerValues);
            } else {
                assert (decodeFailure != null);
                throw decodeFailure;
            }
        }
    }
}

