/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.QueryStringEncoder;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public class HttpParameterEncoder
implements ChannelEncoder {
    private final MessageEncoder nameEncoder;
    private final List<MessageEncoder> valueEncoders;

    public HttpParameterEncoder(MessageEncoder nameEncoder, List<MessageEncoder> valueEncoders) {
        this.nameEncoder = nameEncoder;
        this.valueEncoders = valueEncoders;
    }

    @Override
    public void encode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        QueryStringEncoder query = httpConfig.getWriteQuery();
        if (query == null) {
            ChannelAddress remoteAddress = Channels.remoteAddress(channel);
            URI httpRemoteURI = remoteAddress.getLocation();
            query = new QueryStringEncoder(httpRemoteURI.toString());
            httpConfig.setWriteQuery(query);
        }
        ChannelBufferFactory bufferFactory = httpConfig.getBufferFactory();
        String paramName = this.nameEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
        for (MessageEncoder valueEncoder : this.valueEncoders) {
            String paramValue = valueEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
            query.addParam(paramName, paramValue);
        }
    }

    public String toString() {
        return String.format("http:parameter %s %s", this.nameEncoder, this.valueEncoders);
    }
}

