/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpTrailerEncoder
implements ChannelEncoder {
    private final MessageEncoder nameEncoder;
    private final List<MessageEncoder> valueEncoders;

    public HttpTrailerEncoder(MessageEncoder nameEncoder, List<MessageEncoder> valueEncoders) {
        this.nameEncoder = nameEncoder;
        this.valueEncoders = valueEncoders;
    }

    @Override
    public void encode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        HttpHeaders writeTrailers = httpConfig.getWriteTrailers();
        ChannelBufferFactory bufferFactory = httpConfig.getBufferFactory();
        String headerName = this.nameEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
        if (this.valueEncoders.size() == 1) {
            MessageEncoder valueEncoder = this.valueEncoders.get(0);
            String headerValue = valueEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
            writeTrailers.add(headerName, (Object)headerValue);
        } else {
            for (MessageEncoder valueEncoder : this.valueEncoders) {
                String headerValue = valueEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
                writeTrailers.add(headerName, (Object)headerValue);
            }
        }
    }

    public String toString() {
        return String.format("http:trailer %s %s", this.nameEncoder, this.valueEncoders);
    }
}

