/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.StandardCharsets;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpVersionEncoder
implements ChannelEncoder {
    private MessageEncoder versionEncoder;

    public HttpVersionEncoder(MessageEncoder versionEncoder) {
        this.versionEncoder = versionEncoder;
    }

    @Override
    public void encode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        ChannelBufferFactory bufferFactory = httpConfig.getBufferFactory();
        String versionName = this.versionEncoder.encode(bufferFactory).toString(StandardCharsets.US_ASCII);
        HttpVersion version = HttpVersion.valueOf((String)versionName);
        httpConfig.setVersion(version);
    }

    public String toString() {
        return String.format("http:version %s", this.versionEncoder);
    }
}

