/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;

public class ConnectHandler
extends AbstractCommandHandler {
    private final SocketAddress remoteAddress;

    public ConnectHandler(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture connectFuture = Channels.future((Channel)ctx.getChannel(), (boolean)true);
        Channels.connect((ChannelHandlerContext)ctx, (ChannelFuture)connectFuture, (SocketAddress)this.remoteAddress);
        connectFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    handlerFuture.setSuccess();
                } else {
                    handlerFuture.setFailure((Throwable)new ScriptProgressException(ConnectHandler.this.getRegionInfo(), "connect aborted"));
                }
            }
        });
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append("connect");
    }
}

