/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;

public class WriteAdviseHandler
extends AbstractCommandHandler {
    private final Object value;
    private final List<ChannelEncoder> encoders;

    public WriteAdviseHandler(Object value, ChannelEncoder encoder) {
        this(value, Collections.singletonList(encoder));
    }

    public WriteAdviseHandler(Object value, List<ChannelEncoder> encoders) {
        Objects.requireNonNull(encoders, "encoders");
        if (encoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one encoder");
        }
        this.value = value;
        this.encoders = encoders;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            for (ChannelEncoder encoder : this.encoders) {
                encoder.encode(channel);
            }
            Channels.adviseOutput(ctx, this.getHandlerFuture(), this.value);
        }
        catch (Exception e) {
            this.getHandlerFuture().setFailure((Throwable)e);
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("write advise %s %s", this.value, this.encoders));
    }
}

