/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.event;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.ExecutionHandler;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAdviseEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAdviseEvent;

public abstract class AbstractEventHandler
extends ExecutionHandler {
    protected static final EnumSet<ChannelEventKind> DEFAULT_INTERESTED_EVENTS = EnumSet.complementOf(EnumSet.of(ChannelEventKind.CHILD_OPEN, new ChannelEventKind[]{ChannelEventKind.CHILD_CLOSED, ChannelEventKind.WRITE_COMPLETED, ChannelEventKind.INTEREST_OPS, ChannelEventKind.EXCEPTION, ChannelEventKind.IDLE_STATE, ChannelEventKind.OUTPUT_SHUTDOWN, ChannelEventKind.FLUSHED, ChannelEventKind.UNKNOWN}));
    private final Set<ChannelEventKind> interestEvents;
    private final Set<ChannelEventKind> expectedEvents;

    protected AbstractEventHandler(Set<ChannelEventKind> expectedEvents) {
        this(DEFAULT_INTERESTED_EVENTS, expectedEvents);
    }

    protected AbstractEventHandler(Set<ChannelEventKind> interestEvents, Set<ChannelEventKind> expectedEvents) {
        this.interestEvents = interestEvents;
        this.expectedEvents = expectedEvents;
    }

    @Override
    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEventKind eventAsKind = AbstractEventHandler.asEventKind(evt);
        ChannelFuture handlerFuture = this.getHandlerFuture();
        assert (handlerFuture != null);
        if (handlerFuture.isDone() || !this.interestEvents.contains((Object)eventAsKind)) {
            ctx.sendUpstream(evt);
        } else if (!this.expectedEvents.contains((Object)eventAsKind)) {
            this.handleUnexpectedEvent(ctx, evt);
        } else {
            super.handleUpstream1(ctx, evt);
        }
    }

    protected void handleUnexpectedEvent(ChannelHandlerContext ctx, ChannelEvent evt) {
        ChannelEventKind eventAsKind = AbstractEventHandler.asEventKind(evt);
        try {
            switch (eventAsKind) {
                case OPEN: {
                    throw new ScriptProgressException(this.getRegionInfo(), "opened");
                }
                case BOUND: {
                    throw new ScriptProgressException(this.getRegionInfo(), "bound");
                }
                case CONNECTED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "connected");
                }
                case DISCONNECTED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "disconnected");
                }
                case UNBOUND: {
                    throw new ScriptProgressException(this.getRegionInfo(), "unbound");
                }
                case CLOSED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "closed");
                }
                case FLUSHED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "flushed");
                }
                case READ_ABORTED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "read aborted");
                }
                case WRITE_ABORTED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "write aborted");
                }
                case READ_ADVISED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "read advised ...");
                }
                case WRITE_ADVISED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "write advised ...");
                }
                case MESSAGE: {
                    throw new ScriptProgressException(this.getRegionInfo(), "read ...");
                }
                case INPUT_SHUTDOWN: {
                    throw new ScriptProgressException(this.getRegionInfo(), "read closed");
                }
                case OUTPUT_SHUTDOWN: {
                    throw new ScriptProgressException(this.getRegionInfo(), "write closed");
                }
                case CHILD_OPEN: {
                    throw new ScriptProgressException(this.getRegionInfo(), "child opened");
                }
                case CHILD_CLOSED: {
                    throw new ScriptProgressException(this.getRegionInfo(), "child closed");
                }
            }
            String message = String.format("Unexpected event |%s| for handler %s", new Object[]{eventAsKind, ((Object)((Object)this)).getClass()});
            ChannelException exception = new ChannelException(message);
            if (evt instanceof ExceptionEvent) {
                Throwable cause = ((ExceptionEvent)evt).getCause();
                exception.initCause(cause);
            }
            this.getHandlerFuture().setFailure((Throwable)exception);
        }
        catch (ScriptProgressException e) {
            this.getHandlerFuture().setFailure((Throwable)e);
        }
    }

    private static ChannelEventKind asEventKind(ChannelEvent evt) {
        if (evt instanceof ReadAdviseEvent) {
            return ChannelEventKind.READ_ADVISED;
        }
        if (evt instanceof WriteAdviseEvent) {
            return ChannelEventKind.WRITE_ADVISED;
        }
        if (evt instanceof ReadAbortEvent) {
            return ChannelEventKind.READ_ABORTED;
        }
        if (evt instanceof WriteAbortEvent) {
            return ChannelEventKind.WRITE_ABORTED;
        }
        if (evt instanceof ShutdownInputEvent) {
            return ChannelEventKind.INPUT_SHUTDOWN;
        }
        if (evt instanceof ShutdownOutputEvent) {
            return ChannelEventKind.OUTPUT_SHUTDOWN;
        }
        if (evt instanceof FlushEvent) {
            return ChannelEventKind.FLUSHED;
        }
        if (evt instanceof MessageEvent) {
            return ChannelEventKind.MESSAGE;
        }
        if (evt instanceof WriteCompletionEvent) {
            return ChannelEventKind.WRITE_COMPLETED;
        }
        if (evt instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)evt;
            Object value = cse.getValue();
            switch (cse.getState()) {
                case OPEN: {
                    return Boolean.TRUE.equals(value) ? ChannelEventKind.OPEN : ChannelEventKind.CLOSED;
                }
                case BOUND: {
                    return value != null ? ChannelEventKind.BOUND : ChannelEventKind.UNBOUND;
                }
                case CONNECTED: {
                    return value != null ? ChannelEventKind.CONNECTED : ChannelEventKind.DISCONNECTED;
                }
                case INTEREST_OPS: {
                    return ChannelEventKind.INTEREST_OPS;
                }
            }
        }
        if (evt instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent ccse = (ChildChannelStateEvent)evt;
            Channel child = ccse.getChildChannel();
            return child.isOpen() ? ChannelEventKind.CHILD_OPEN : ChannelEventKind.CHILD_CLOSED;
        }
        if (evt instanceof ExceptionEvent) {
            return ChannelEventKind.EXCEPTION;
        }
        if (evt instanceof IdleStateEvent) {
            return ChannelEventKind.IDLE_STATE;
        }
        return ChannelEventKind.UNKNOWN;
    }

    public static enum ChannelEventKind {
        CHILD_OPEN,
        CHILD_CLOSED,
        OPEN,
        BOUND,
        CONNECTED,
        MESSAGE,
        WRITE_COMPLETED,
        DISCONNECTED,
        UNBOUND,
        CLOSED,
        EXCEPTION,
        INTEREST_OPS,
        IDLE_STATE,
        INPUT_SHUTDOWN,
        OUTPUT_SHUTDOWN,
        FLUSHED,
        UNKNOWN,
        READ_ABORTED,
        WRITE_ABORTED,
        READ_ADVISED,
        WRITE_ADVISED;

    }
}

