/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.event;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.el.ELException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.event.AbstractEventHandler;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAdviseEvent;

public class WriteAdvisedHandler
extends AbstractEventHandler {
    private final Object value;
    private final List<ChannelDecoder> decoders;

    public WriteAdvisedHandler(Object value, ChannelDecoder decoder) {
        this(value, Collections.singletonList(decoder));
    }

    public WriteAdvisedHandler(Object value, List<ChannelDecoder> decoders) {
        super(EnumSet.of(AbstractEventHandler.ChannelEventKind.WRITE_ADVISED));
        this.value = value;
        this.decoders = decoders;
    }

    @Override
    public void outputAdvised(ChannelHandlerContext ctx, WriteAdviseEvent e) {
        block6: {
            ChannelFuture handlerFuture = this.getHandlerFuture();
            assert (handlerFuture != null);
            try {
                if (!Objects.equals(this.value, e.getValue())) {
                    handlerFuture.setFailure((Throwable)new ScriptProgressException(this.getRegionInfo(), String.valueOf(e.getValue())));
                    break block6;
                }
                Channel channel = ctx.getChannel();
                for (ChannelDecoder decoder : this.decoders) {
                    boolean decoded = decoder.decode(channel);
                    if (decoded) continue;
                    handlerFuture.setFailure((Throwable)new ScriptProgressException(this.getRegionInfo(), "decode failed"));
                    break block6;
                }
                handlerFuture.setSuccess();
            }
            catch (ELException ele) {
                ScriptProgressException exception = new ScriptProgressException(this.getRegionInfo(), ele.getMessage());
                exception.initCause(ele);
                handlerFuture.setFailure((Throwable)exception);
            }
            catch (Exception ex) {
                handlerFuture.setFailure((Throwable)ex);
            }
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("read advised %s %s", this.value, this.decoders));
    }
}

