/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.visitor;

import java.util.List;
import org.kaazing.k3po.lang.internal.ast.AstAcceptNode;
import org.kaazing.k3po.lang.internal.ast.AstAcceptableNode;
import org.kaazing.k3po.lang.internal.ast.AstAcceptedNode;
import org.kaazing.k3po.lang.internal.ast.AstBoundNode;
import org.kaazing.k3po.lang.internal.ast.AstChildClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstChildOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAdviseNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAdvisedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstReadClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstReadNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstReadValueNode;
import org.kaazing.k3po.lang.internal.ast.AstRejectedNode;
import org.kaazing.k3po.lang.internal.ast.AstScriptNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamableNode;
import org.kaazing.k3po.lang.internal.ast.AstUnbindNode;
import org.kaazing.k3po.lang.internal.ast.AstUnboundNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAdviseNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAdvisedNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteFlushNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteValueNode;

public class InjectEventsVisitor
implements AstNode.Visitor<AstScriptNode, State> {
    public AstScriptNode visit(AstScriptNode script, State state) {
        AstScriptNode newScript = new AstScriptNode();
        newScript.setRegionInfo(script.getRegionInfo());
        newScript.getProperties().addAll(script.getProperties());
        state.streams = newScript.getStreams();
        for (AstStreamNode stream : script.getStreams()) {
            stream.accept((AstNode.Visitor)this, (Object)state);
        }
        return newScript;
    }

    public AstScriptNode visit(AstPropertyNode propertyNode, State state) {
        return null;
    }

    public AstScriptNode visit(AstAcceptNode acceptNode, State state) {
        state.connectivityState = ConnectivityState.NONE;
        AstAcceptNode newAcceptNode = new AstAcceptNode(acceptNode);
        state.streamables = newAcceptNode.getStreamables();
        for (AstStreamableNode streamable : acceptNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        for (AstAcceptableNode acceptable : acceptNode.getAcceptables()) {
            acceptable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newAcceptNode);
        return null;
    }

    public AstScriptNode visit(AstAcceptedNode acceptedNode, State state) {
        state.connectivityState = ConnectivityState.NONE;
        AstAcceptedNode newAcceptedNode = new AstAcceptedNode();
        newAcceptedNode.setRegionInfo(acceptedNode.getRegionInfo());
        newAcceptedNode.setAcceptName(acceptedNode.getAcceptName());
        state.streamables = newAcceptedNode.getStreamables();
        for (AstStreamableNode streamable : acceptedNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newAcceptedNode);
        return null;
    }

    public AstScriptNode visit(AstRejectedNode rejectedNode, State state) {
        state.connectivityState = ConnectivityState.NONE;
        AstRejectedNode newRejectedNode = new AstRejectedNode();
        newRejectedNode.setRegionInfo(rejectedNode.getRegionInfo());
        newRejectedNode.setAcceptName(rejectedNode.getAcceptName());
        state.streamables = newRejectedNode.getStreamables();
        for (AstStreamableNode streamable : rejectedNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newRejectedNode);
        return null;
    }

    public AstScriptNode visit(AstConnectNode connectNode, State state) {
        state.connectivityState = ConnectivityState.NONE;
        AstConnectNode newConnectNode = new AstConnectNode(connectNode);
        state.streamables = newConnectNode.getStreamables();
        for (AstStreamableNode streamable : connectNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        state.streams.add(newConnectNode);
        return null;
    }

    public AstScriptNode visit(AstReadAwaitNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAwaitNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadNotifyNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteNotifyNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteValueNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected write before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstDisconnectNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected disconnect before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstUnbindNode node, State state) {
        switch (state.connectivityState) {
            case DISCONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected unbind before disconnected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstCloseNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected close before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstWriteAbortNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected write abort before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstReadAbortNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected read abort before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstChildOpenedNode childOpenedNode, State state) {
        state.streamables.add(childOpenedNode);
        return null;
    }

    public AstScriptNode visit(AstChildClosedNode childClosedNode, State state) {
        state.streamables.add(childClosedNode);
        return null;
    }

    public AstScriptNode visit(AstOpenedNode openedNode, State state) {
        switch (state.connectivityState) {
            case NONE: {
                state.connectivityState = ConnectivityState.OPENED;
                state.streamables.add(openedNode);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: opened");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstBoundNode boundNode, State state) {
        switch (state.connectivityState) {
            case NONE: {
                AstOpenedNode openedNode = new AstOpenedNode();
                openedNode.setRegionInfo(boundNode.getRegionInfo());
                openedNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case OPENED: {
                state.streamables.add(boundNode);
                state.connectivityState = ConnectivityState.BOUND;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: bound");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstConnectedNode connectedNode, State state) {
        switch (state.connectivityState) {
            case NONE: 
            case OPENED: {
                AstBoundNode boundNode = new AstBoundNode();
                boundNode.setRegionInfo(connectedNode.getRegionInfo());
                boundNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case BOUND: {
                state.streamables.add(connectedNode);
                state.connectivityState = ConnectivityState.CONNECTED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstConnectAbortNode connectAbortNode, State state) {
        switch (state.connectivityState) {
            case NONE: 
            case OPENED: {
                AstBoundNode boundNode = new AstBoundNode();
                boundNode.setRegionInfo(connectAbortNode.getRegionInfo());
                boundNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case BOUND: {
                state.streamables.add(connectAbortNode);
                state.connectivityState = ConnectivityState.CLOSED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected connect abort");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstConnectAbortedNode connectAbortedNode, State state) {
        switch (state.connectivityState) {
            case NONE: 
            case OPENED: {
                AstBoundNode boundNode = new AstBoundNode();
                boundNode.setRegionInfo(connectAbortedNode.getRegionInfo());
                boundNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case BOUND: {
                state.streamables.add(connectAbortedNode);
                state.connectivityState = ConnectivityState.CLOSED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: connect aborted");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstReadValueNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected read before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstDisconnectedNode disconnectedNode, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(disconnectedNode);
                state.connectivityState = ConnectivityState.DISCONNECTED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: disconnected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstUnboundNode unboundNode, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                AstDisconnectedNode disconnectedNode = new AstDisconnectedNode();
                disconnectedNode.setRegionInfo(unboundNode.getRegionInfo());
                disconnectedNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case DISCONNECTED: {
                state.streamables.add(unboundNode);
                state.connectivityState = ConnectivityState.UNBOUND;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: unbound");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstClosedNode closedNode, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case DISCONNECTED: {
                AstUnboundNode unboundNode = new AstUnboundNode();
                unboundNode.setRegionInfo(closedNode.getRegionInfo());
                unboundNode.accept((AstNode.Visitor)this, (Object)state);
                break;
            }
        }
        switch (state.connectivityState) {
            case UNBOUND: {
                state.streamables.add(closedNode);
                state.connectivityState = ConnectivityState.CLOSED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event: closed");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstReadAbortedNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected read aborted before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstWriteAbortedNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                state.streamables.add(node);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected write aborted before connected");
            }
        }
        return null;
    }

    public AstScriptNode visit(AstReadConfigNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteConfigNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadAdviseNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAdviseNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadAdvisedNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteAdvisedNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadClosedNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteCloseNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteFlushNode node, State state) {
        switch (state.connectivityState) {
            case CONNECTED: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected \"%s\" before connected", node));
            }
        }
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstReadOptionNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public AstScriptNode visit(AstWriteOptionNode node, State state) {
        state.streamables.add(node);
        return null;
    }

    public static final class State {
        private List<AstStreamNode> streams;
        private List<AstStreamableNode> streamables;
        private ConnectivityState connectivityState;
    }

    public static enum ConnectivityState {
        NONE,
        OPENED,
        BOUND,
        CONNECTED,
        DISCONNECTED,
        UNBOUND,
        CLOSED;

    }
}

