/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.control.ControlMessage;
import org.kaazing.k3po.driver.internal.control.ErrorMessage;
import org.kaazing.k3po.driver.internal.control.FinishedMessage;
import org.kaazing.k3po.driver.internal.control.NotifiedMessage;
import org.kaazing.k3po.driver.internal.control.NotifyMessage;
import org.kaazing.k3po.driver.internal.control.PreparedMessage;
import org.kaazing.k3po.driver.internal.control.StartedMessage;

public class ControlEncoder
extends OneToOneEncoder {
    private static final byte LF = 10;

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object message) throws Exception {
        if (message instanceof ControlMessage) {
            ControlMessage controlMessage = (ControlMessage)message;
            switch (controlMessage.getKind()) {
                case PREPARED: {
                    return this.encodePreparedMessage(ctx, channel, (PreparedMessage)controlMessage);
                }
                case STARTED: {
                    return this.encodeStartedMessage(ctx, channel, (StartedMessage)controlMessage);
                }
                case ERROR: {
                    return this.encodeErrorMessage(ctx, channel, (ErrorMessage)controlMessage);
                }
                case FINISHED: {
                    return this.encodeFinishedMessage(ctx, channel, (FinishedMessage)controlMessage);
                }
                case NOTIFY: {
                    return this.encodeNotifyMessage(ctx, channel, (NotifyMessage)controlMessage);
                }
                case NOTIFIED: {
                    return this.encodedNotifiedMessage(ctx, channel, (NotifiedMessage)controlMessage);
                }
            }
        }
        return message;
    }

    private Object encodePreparedMessage(ChannelHandlerContext ctx, Channel channel, PreparedMessage preparedMessage) {
        ControlMessage.Kind kind = preparedMessage.getKind();
        String script = preparedMessage.getScript();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        for (String barrier : preparedMessage.getBarriers()) {
            if (barrier.startsWith("~")) continue;
            ControlEncoder.encodeHeader("barrier", barrier, buf);
        }
        return ControlEncoder.encodeContent(script, buf);
    }

    private Object encodeStartedMessage(ChannelHandlerContext ctx, Channel channel, StartedMessage startedMessage) {
        ControlMessage.Kind kind = startedMessage.getKind();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        return ControlEncoder.encodeNoContent(buf);
    }

    private Object encodeErrorMessage(ChannelHandlerContext ctx, Channel channel, ErrorMessage errorMessage) {
        ControlMessage.Kind kind = errorMessage.getKind();
        String summary = errorMessage.getSummary();
        String description = errorMessage.getDescription();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        ControlEncoder.encodeHeader("summary", summary, buf);
        return ControlEncoder.encodeContent(description, buf);
    }

    private Object encodeFinishedMessage(ChannelHandlerContext ctx, Channel channel, FinishedMessage finishedMessage) {
        ControlMessage.Kind kind = finishedMessage.getKind();
        String script = finishedMessage.getScript();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        for (String barrier : finishedMessage.getCompletedBarriers()) {
            if (barrier.startsWith("~")) continue;
            ControlEncoder.encodeHeader("notified", barrier, buf);
        }
        for (String barrier : finishedMessage.getIncompleteBarriers()) {
            if (barrier.startsWith("~")) continue;
            ControlEncoder.encodeHeader("awaiting", barrier, buf);
        }
        return ControlEncoder.encodeContent(script, buf);
    }

    private Object encodeNotifyMessage(ChannelHandlerContext ctx, Channel channel, NotifyMessage notifyMessage) {
        ControlMessage.Kind kind = notifyMessage.getKind();
        String barrier = notifyMessage.getBarrier();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        ControlEncoder.encodeHeader("barrier", barrier, buf);
        return ControlEncoder.encodeNoContent(buf);
    }

    private Object encodedNotifiedMessage(ChannelHandlerContext ctx, Channel channel, NotifiedMessage notifiedMessage) {
        ControlMessage.Kind kind = notifiedMessage.getKind();
        String barrier = notifiedMessage.getBarrier();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, buf);
        ControlEncoder.encodeHeader("barrier", barrier, buf);
        return ControlEncoder.encodeNoContent(buf);
    }

    private static void encodeInitial(ControlMessage.Kind kind, ChannelBuffer buf) {
        buf.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)kind.toString(), (Charset)CharsetUtil.UTF_8));
        buf.writeByte(10);
    }

    private static void encodeHeader(String bufName, Object bufValue, ChannelBuffer buf) {
        if (bufValue != null) {
            buf.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)String.format("%s:%s", bufName, bufValue), (Charset)CharsetUtil.UTF_8));
            buf.writeByte(10);
        }
    }

    private static ChannelBuffer encodeNoContent(ChannelBuffer buf) {
        buf.writeByte(10);
        return buf;
    }

    private static ChannelBuffer encodeContent(String content, ChannelBuffer buf) {
        if (content == null) {
            return ControlEncoder.encodeNoContent(buf);
        }
        ChannelBuffer contentBuf = ChannelBuffers.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8);
        ControlEncoder.encodeHeader("content-length", contentBuf.readableBytes(), buf);
        buf.writeByte(10);
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{buf, contentBuf});
    }
}

