/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.control.ControlMessage;
import org.kaazing.k3po.driver.internal.control.ErrorMessage;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;

public class ControlUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ControlUpstreamHandler.class);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        ControlMessage message = (ControlMessage)evt.getMessage();
        try {
            switch (message.getKind()) {
                case PREPARE: {
                    this.prepareReceived(ctx, evt);
                    break;
                }
                case START: {
                    this.startReceived(ctx, evt);
                    break;
                }
                case ABORT: {
                    this.abortReceived(ctx, evt);
                    break;
                }
                case NOTIFY: {
                    this.notifyReceived(ctx, evt);
                    break;
                }
                case AWAIT: {
                    this.awaitReceived(ctx, evt);
                    break;
                }
                case CLOSE: {
                    this.closeReceived(ctx, evt);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unexpected control message: %s", new Object[]{message.getKind()}));
                }
            }
        }
        catch (Exception ex) {
            this.sendErrorMessage(ctx, ex);
        }
    }

    public void prepareReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void startReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void abortReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void notifyReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void awaitReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void closeReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        String msg = "Control channel caught exception event: ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg, e.getCause());
        } else {
            LOGGER.info(msg + e.getCause());
        }
    }

    protected void sendErrorMessage(ChannelHandlerContext ctx, Throwable throwable) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setDescription(throwable.getMessage());
        if (throwable instanceof ScriptParseException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Caught exception trying to parse script. Sending error to client", throwable);
            } else {
                LOGGER.error("Caught exception trying to parse script. Sending error to client. Due to " + throwable);
            }
            errorMessage.setSummary("Parse Error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)errorMessage);
        } else {
            LOGGER.error("Internal error. Sending error to client", throwable);
            errorMessage.setSummary("Internal error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)errorMessage);
        }
    }

    protected void sendErrorMessage(ChannelHandlerContext ctx, String description) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setSummary("Internal error");
        errorMessage.setDescription(description);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.error("Sending error to client:" + description);
        }
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)errorMessage);
    }
}

