/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.ext.tls.bootstrap;

import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannel;
import org.jboss.netty.handler.ssl.SslHandler;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChannelConfig;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChildChannel;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChildChannelSink;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsServerChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.ChannelConfig;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.SimpleChannelHandler;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAbortEvent;

public class TlsChildChannelSource
extends SimpleChannelHandler {
    private final NavigableMap<ChannelAddress, TlsServerChannel> tlsBindings;
    private volatile TlsChildChannel tlsChildChannel;

    public TlsChildChannelSource(NavigableMap<ChannelAddress, TlsServerChannel> tlsBindings) {
        this.tlsBindings = tlsBindings;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel transport = ctx.getChannel();
        ChannelPipeline pipeline = ctx.getPipeline();
        SslHandler handler = (SslHandler)pipeline.get(SslHandler.class);
        SSLEngine tlsEngine = handler.getEngine();
        ExtendedSSLSession tlsSession = (ExtendedSSLSession)tlsEngine.getSession();
        List<SNIServerName> sniServerNames = tlsSession.getRequestedServerNames();
        Map.Entry<ChannelAddress, TlsServerChannel> tlsBinding = null;
        if (sniServerNames.size() > 0) {
            SNIHostName sniHostName = (SNIHostName)sniServerNames.get(0);
            String serverName = sniHostName.getAsciiName();
            URI tlsLocation = URI.create(String.format("tls://%s", serverName));
            ChannelAddress transportCandidate = (ChannelAddress)ctx.getChannel().getParent().getAttachment();
            ChannelAddress candidate = new ChannelAddress(tlsLocation, transportCandidate);
            tlsBinding = this.tlsBindings.floorEntry(candidate);
        }
        if (tlsBinding == null) {
            transport.close();
        } else {
            TlsServerChannel parent = (TlsServerChannel)((Object)tlsBinding.getValue());
            ChannelFactory factory = parent.getFactory();
            ChannelConfig parentConfig = (ChannelConfig)parent.getConfig();
            ChannelPipelineFactory childPipelineFactory = parentConfig.getPipelineFactory();
            ChannelPipeline childPipeline = childPipelineFactory.getPipeline();
            ChannelAddress tlsLocalAddress = parent.getLocalAddress();
            URI tlsLocation = tlsLocalAddress.getLocation();
            ChannelAddress remoteAddress = org.kaazing.k3po.driver.internal.channel.Channels.remoteAddress(transport);
            ChannelAddress tlsRemoteAddress = new ChannelAddress(tlsLocation, remoteAddress, true);
            TlsChildChannelSink sink = new TlsChildChannelSink(transport);
            final TlsChildChannel tlsChildChannel = new TlsChildChannel((ServerChannel)parent, factory, childPipeline, (ChannelSink)sink);
            TlsChannelConfig tlsChildConfig = (TlsChannelConfig)tlsChildChannel.getConfig();
            tlsChildConfig.setParameters(tlsEngine.getSSLParameters());
            ChannelFuture tlsCloseFuture = handler.getSSLEngineInboundCloseFuture();
            tlsCloseFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (tlsChildChannel.setReadClosed()) {
                        Channels.fireInputShutdown((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
                    } else {
                        Channels.fireInputShutdown((Channel)tlsChildChannel);
                    }
                }
            });
            transport.getConfig().setBufferFactory(tlsChildConfig.getBufferFactory());
            this.tlsChildChannel = tlsChildChannel;
            this.detectWriteTransportClosed(transport, tlsChildChannel);
            org.jboss.netty.channel.Channels.fireChannelOpen((Channel)tlsChildChannel);
            tlsChildChannel.setLocalAddress(tlsLocalAddress);
            tlsChildChannel.setBound();
            org.jboss.netty.channel.Channels.fireChannelBound((Channel)tlsChildChannel, (SocketAddress)tlsLocalAddress);
            tlsChildChannel.setRemoteAddress(tlsRemoteAddress);
            tlsChildChannel.setConnected();
            org.jboss.netty.channel.Channels.fireChannelConnected((Channel)tlsChildChannel, (SocketAddress)tlsRemoteAddress);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer message = (ChannelBuffer)e.getMessage();
        if (message.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.tlsChildChannel, (Object)message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null) {
            this.tlsChildChannel = null;
            if (tlsChildChannel.setReadClosed() || tlsChildChannel.setWriteClosed()) {
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)tlsChildChannel, (Throwable)e.getCause());
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            }
        }
        Channel channel = ctx.getChannel();
        channel.close();
    }

    @Override
    public void inputAborted(ChannelHandlerContext ctx, ReadAbortEvent e) {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null && tlsChildChannel.setReadAborted()) {
            if (tlsChildChannel.setReadClosed()) {
                Channels.fireInputAborted((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            } else {
                Channels.fireInputAborted((Channel)tlsChildChannel);
            }
        }
    }

    @Override
    public void outputAborted(ChannelHandlerContext ctx, WriteAbortEvent e) {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null && tlsChildChannel.setWriteAborted()) {
            if (tlsChildChannel.setWriteClosed()) {
                Channels.fireOutputAborted((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            } else {
                Channels.fireOutputAborted((Channel)tlsChildChannel);
            }
        }
    }

    @Override
    public void inputShutdown(ChannelHandlerContext ctx, ShutdownInputEvent e) {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null) {
            if (tlsChildChannel.setReadClosed()) {
                Channels.fireInputShutdown((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            } else {
                Channels.fireInputShutdown((Channel)tlsChildChannel);
            }
        }
    }

    @Override
    public void outputShutdown(ChannelHandlerContext ctx, ShutdownOutputEvent e) {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null) {
            if (tlsChildChannel.setWriteClosed()) {
                Channels.fireOutputShutdown((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            } else {
                Channels.fireOutputShutdown((Channel)tlsChildChannel);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SslHandler tlsHandler;
        SSLEngine tlsEngine;
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null && !(tlsEngine = (tlsHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class)).getEngine()).isInboundDone() && tlsChildChannel.setReadAborted()) {
            Channels.fireInputAborted((Channel)tlsChildChannel);
        }
        super.channelDisconnected(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        TlsChildChannel tlsChildChannel = this.tlsChildChannel;
        if (tlsChildChannel != null) {
            this.tlsChildChannel = null;
            if (tlsChildChannel.setReadClosed()) {
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
            }
        }
    }

    private void detectWriteTransportClosed(final Channel transport, final TlsChildChannel tlsChildChannel) {
        Objects.requireNonNull(tlsChildChannel);
        final ChannelFutureListener closeListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (tlsChildChannel.setWriteClosed()) {
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsChildChannel);
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsChildChannel);
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsChildChannel);
                }
            }
        };
        transport.getCloseFuture().addListener(closeListener);
        tlsChildChannel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                transport.getCloseFuture().removeListener(closeListener);
            }
        });
    }
}

