/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.ext.tls.bootstrap;

import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.ssl.SslHandler;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsClientChannel;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.ReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.SimpleChannelHandler;
import org.kaazing.k3po.driver.internal.netty.channel.WriteAbortEvent;

public class TlsClientChannelSource
extends SimpleChannelHandler {
    volatile TlsClientChannel tlsClientChannel;

    public void setTlsChannel(TlsClientChannel tlsClientChannel) {
        assert (this.tlsClientChannel == null);
        this.tlsClientChannel = tlsClientChannel;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer message = (ChannelBuffer)e.getMessage();
        if (message.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.tlsClientChannel, (Object)message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.tlsClientChannel != null) {
            TlsClientChannel tlsClientChannel = this.tlsClientChannel;
            this.tlsClientChannel = null;
            if (tlsClientChannel.setReadClosed()) {
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)tlsClientChannel, (Throwable)e.getCause());
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            }
        }
        Channel channel = ctx.getChannel();
        channel.close();
    }

    @Override
    public void inputAborted(ChannelHandlerContext ctx, ReadAbortEvent e) {
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null && tlsClientChannel.setReadAborted()) {
            if (tlsClientChannel.setReadClosed()) {
                Channels.fireInputAborted((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            } else {
                Channels.fireInputAborted((Channel)tlsClientChannel);
            }
        }
    }

    @Override
    public void outputAborted(ChannelHandlerContext ctx, WriteAbortEvent e) {
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null && tlsClientChannel.setWriteAborted()) {
            if (tlsClientChannel.setWriteClosed()) {
                Channels.fireOutputAborted((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            } else {
                Channels.fireOutputAborted((Channel)tlsClientChannel);
            }
        }
    }

    @Override
    public void inputShutdown(ChannelHandlerContext ctx, ShutdownInputEvent e) {
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null) {
            if (tlsClientChannel.setReadClosed()) {
                Channels.fireInputShutdown((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            } else {
                Channels.fireInputShutdown((Channel)tlsClientChannel);
            }
        }
    }

    @Override
    public void outputShutdown(ChannelHandlerContext ctx, ShutdownOutputEvent e) {
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null) {
            if (tlsClientChannel.setWriteClosed()) {
                Channels.fireOutputShutdown((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            } else {
                Channels.fireOutputShutdown((Channel)tlsClientChannel);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SslHandler tlsHandler;
        SSLEngine tlsEngine;
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null && !(tlsEngine = (tlsHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class)).getEngine()).isInboundDone() && tlsClientChannel.setReadAborted()) {
            Channels.fireInputAborted((Channel)tlsClientChannel);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        TlsClientChannel tlsClientChannel = this.tlsClientChannel;
        if (tlsClientChannel != null) {
            this.tlsClientChannel = null;
            if (tlsClientChannel.setReadClosed()) {
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)tlsClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)tlsClientChannel);
            }
        }
    }
}

